﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.BusinessLogic.Serializer
{
    /// <summary>
    /// プレビューデータのシリアライザです。
    /// </summary>
    public class PreviewDataSerializer : DataModelSerializer<PreviewData>
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public PreviewDataSerializer()
        {
        }

        /// <summary>
        /// ファイルへのシリアライズを行います。
        /// </summary>
        /// <param name="dataModel">シリアライズする値</param>
        /// <param name="filePath">ファイルパス</param>
        /// <returns>シリアライズ結果を返します。</returns>
        public SerializeResult SerializeToFile(PreviewData dataModel, string filePath)
        {
            SerializeResult result;

            try
            {
                using (FileStream stream = new FileStream(filePath, FileMode.Create, FileAccess.Write))
                {
                    result = (SerializeResult)this.Serialize(dataModel, stream);
                }
            }
            catch (Exception e)
            {
                result = new SerializeResult();

                result.Exception = e;
            }

            return result;
        }

        /// <summary>
        /// ファイルからのデシリアライズを行います。
        /// </summary>
        /// <param name="filePath">ファイルパス</param>
        /// <returns>デシリアライズ結果を返します。</returns>
        public DeserializeResult DeserializeFromFile(string filePath)
        {
            DeserializeResult result;

            try
            {
                using (FileStream stream = new FileStream(filePath, FileMode.Open, FileAccess.Read))
                {
                    result = (DeserializeResult)this.Deserialize(stream);
                }
            }
            catch (Exception e)
            {
                result = new DeserializeResult();

                result.Exception = e;
            }

            return result;
        }
    }
}
