﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.BusinessLogic.ViewerMessages;
using EffectMaker.Foundation.Log;
using EffectMaker.Foundation.Utility;

namespace EffectMaker.BusinessLogic.Protocol
{
    /// <summary>
    /// SendBinaryMessage.
    /// </summary>
    public class ViewerMessage : MessageBase
    {
        /// <summary>
        /// Get the type of the message.
        /// </summary>
        public override MessageTypes MessageType
        {
            get
            {
                return MessageTypes.SendBinary;
            }
        }

        /// <summary>
        /// Get the size of the message.
        /// </summary>
        public override int MessageSize
        {
            get
            {
                return this.ReceivedMessageSize;
            }
        }

        /// <summary>
        /// ビューアメッセージタイプを取得します。
        /// </summary>
        public ViewerMessageType ViewerMessageType { get; private set; }

        /// <summary>
        /// Read message data from binary data.
        /// </summary>
        /// <param name="stream">The stream contains the message's binary data.</param>
        /// <returns>True on success.</returns>
        public override bool Read(System.IO.Stream stream)
        {
            if (base.Read(stream) == false)
            {
                return false;
            }

            // メッセージタイプを取得
            this.ViewerMessageType = (ViewerMessageType)BinaryConversionUtility.ForProtocol.ReadStream<uint>(stream);

            // サイズを取得
            uint size = BinaryConversionUtility.ForProtocol.ReadStream<uint>(stream);

            if (size != 0)
            {
                Logger.Log(LogLevels.Warning, "ViewerMessage.Read(): Invalid message size.");
                return false;
            }

            return true;
        }
    }
}
