﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace EffectMaker.BusinessLogic.Protocol
{
    /// <summary>
    /// メッセージタイプです.
    /// </summary>
    public enum MessageType : int
    {
        /// <summary>
        /// 未定義データ.
        /// </summary>
        Unkonwn = 0,

        /// <summary>
        /// 制御メッセージ.
        /// </summary>
        Control = 1,

        /// <summary>
        /// バイナリ転送メッセージ.
        /// </summary>
        SendBinary = 2,

        /// <summary>
        /// 生成メッセージ.
        /// </summary>
        Create = 3,

        /// <summary>
        /// 4Byte編集メッセージ.
        /// </summary>
        Modify = 4,

        /// <summary>
        /// 削除メッセージ.
        /// </summary>
        Delete = 5,

        /// <summary>
        /// バイナリ削除メッセージ.
        /// </summary>
        RemoveBinary = 6,

        /// <summary>
        /// モデル情報.
        /// </summary>
        ModelInfo = 7,

        /// <summary>
        /// ビューアからのエディタ操作要求メッセージ.
        /// </summary>
        Operation = 8,
    }

    /// <summary>
    /// ビューアメッセージタイプです。
    /// </summary>
    public enum ViewerMessageType : int
    {
        /// <summary>
        /// ビューア初期設定
        /// </summary>
        Config = 0,

        /// <summary>
        /// フレームを先頭に戻す
        /// </summary>
        ResetFrame = 1,

        /// <summary>
        /// 再生
        /// </summary>
        Play = 2,

        /// <summary>
        /// 一時停止
        /// </summary>
        Pause = 3,

        /// <summary>
        /// 停止
        /// </summary>
        Stop = 4,

        /// <summary>
        /// コマ送り
        /// </summary>
        StepFrame = 5,

        /// <summary>
        /// 強制フェード
        /// </summary>
        ForceFade = 6,

        /// <summary>
        /// 範囲設定
        /// </summary>
        SetRange = 7,

        /// <summary>
        /// カメラ
        /// </summary>
        Camera = 8,

        /// <summary>
        /// 背景画像
        /// </summary>
        BackgroundImage = 9,

        /// <summary>
        /// ビューアからのリクエスト
        /// </summary>
        RequestToEditor = 10,

        /// <summary>
        /// 表示/非表示
        /// </summary>
        Visibility = 11,

        /// <summary>
        /// アプリケーション初期化完了
        /// </summary>
        AppInitialized = 12,

        /// <summary>
        /// 描画順
        /// </summary>
        DrawOrder = 13,

        /// <summary>
        /// キャプチャ
        /// </summary>
        Capture = 14,
    }

    /// <summary>
    /// ビューアからの操作タイプ.
    /// </summary>
    public enum OperationType : int
    {
        /// <summary>
        /// 何もしない.
        /// </summary>
        None = -1,

        /// <summary>
        /// ファイルを開く.
        /// </summary>
        Open = 0,

        /// <summary>
        /// ファイルを閉じる.
        /// </summary>
        Close = 1,

        /// <summary>
        /// 新規作成.
        /// </summary>
        Create = 2,

        /// <summary>
        /// 複製.
        /// </summary>
        Duplicate = 3,

        /// <summary>
        /// リンクを作成
        /// </summary>
        LinkEset = 4,

        /// <summary>
        /// リンクを破棄
        /// </summary>
        UnlinkEset = 5,
    }

    /// <summary>
    /// ModelInfoMessageのタイプです.
    /// </summary>
    public enum ModelInfoMessageType : int
    {
        /// <summary>
        /// データクリア
        /// </summary>
        Clear = 0,

        /// <summary>
        /// モデル情報送信開始
        /// </summary>
        Begin = 1,

        /// <summary>
        /// モデル情報送信
        /// </summary>
        Send = 2,

        /// <summary>
        /// モデル情報送信終了
        /// </summary>
        End = 3,

        /// <summary>
        /// モデル情報削除
        /// </summary>
        Remove = 4,
    }
}
