﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;

using EffectMaker.Foundation.Serialization;

namespace EffectMaker.BusinessLogic.Options
{
    /// <summary>
    /// Linear Workflow options.
    /// </summary>
    public class LinearWorkflowOptions : OptionsBase
    {
        /// <summary>
        /// Initializes the LinearWorkflowOptions instance.
        /// </summary>
        public LinearWorkflowOptions()
        {
        }

        /// <summary>
        /// Copy the LinearWorkflowOptions instance.
        /// </summary>
        /// <param name="src">The source optins to copy from.</param>
        public LinearWorkflowOptions(LinearWorkflowOptions src)
            : this()
        {
            this.Set(src);
        }

        /// <summary>
        /// Gets or sets the flat telling wether to show warning
        /// when loading textures that differ from the mode.
        /// </summary>
        [XmlAttribute]
        public bool ShowWarning { get; set; }

        /// <summary>
        /// Set data from the source options.
        /// </summary>
        /// <param name="src">The source options.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            var options = src as LinearWorkflowOptions;
            if (options == null)
            {
                return false;
            }

            this.ShowWarning = options.ShowWarning;

            return true;
        }

        /// <summary>
        /// Deserializes from the given XML node.
        /// </summary>
        /// <param name="context">The data context needed for the deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            this.ShowWarning =
                this.ReadAttribute(context, "ShowWarning", this.ShowWarning);

            return true;
        }

        /// <summary>
        /// Serializes this object to a XML node.
        /// </summary>
        /// <param name="context">The data context needed for the serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            this.WriteAttribute(context, "ShowWarning", this.ShowWarning);

            return true;
        }
    }
}
