﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Collections;

namespace EffectMaker.BusinessLogic.DataModelOperation
{
    /// <summary>
    /// EmitterSetData の拡張関数です。
    /// </summary>
    public static class EmitterSetDataExtension
    {
        /// <summary>
        /// エミッタ名とテクスチャファイルパスの対を列挙します。
        /// 列挙するエミッタはバイナリコンバートが有効なものに限ります。
        /// </summary>
        /// <param name="emitterSetData">EmitterSetData</param>
        /// <returns>エミッタ名とテクスチャファイルパスのコレクションを返します。</returns>
        public static IEnumerable<StringPair> EnumerateEmitterNameAndTexturePaths(this EmitterSetData emitterSetData)
        {
            return emitterSetData.AllActiveChildEmitters.SelectMany(x => x.EmitterNameAndTexturePaths);
        }

        /// <summary>
        /// エミッタ名とプリミティブファイルパスの対を列挙します。
        /// プリミティブは G3D プリミティブバイナリに変換するものだけを列挙します。
        /// 列挙するエミッタはバイナリコンバートが有効なものに限ります。
        /// </summary>
        /// <param name="emitterSetData">EmitterSetData</param>
        /// <returns>エミッタ名とプリミティブファイルパスのコレクションを返します。</returns>
        public static IEnumerable<StringPair> EnumerateEmitterNameAndPrimitivePaths(this EmitterSetData emitterSetData)
        {
            return emitterSetData.AllActiveChildEmitters.SelectMany(x => x.EmitterNameAndPrimitivePaths);
        }

        /// <summary>
        /// エミッタ名とプリミティブファイルパスの対を列挙します。
        /// プリミティブは VFX プリミティブバイナリ（独自形式）に変換するものだけを列挙します。
        /// 列挙するエミッタはバイナリコンバートが有効なものに限ります。
        /// </summary>
        /// <param name="emitterSetData">EmitterSetData</param>
        /// <returns>エミッタ名とプリミティブファイルパスのコレクションを返します。</returns>
        public static IEnumerable<StringPair> EnumerateEmitterNameAndOriginalPrimitivePaths(this EmitterSetData emitterSetData)
        {
            return emitterSetData.AllActiveChildEmitters.SelectMany(x => x.EmitterNameAndOriginalPrimitivePaths);
        }

        /// <summary>
        /// エミッタ名とトリミングプリミティブファイルパスの対を列挙します。
        /// 列挙するエミッタはバイナリコンバートが有効なものに限ります。
        /// </summary>
        /// <param name="emitterSetData">EmitterSetData</param>
        /// <returns>エミッタ名とトリミングプリミティブファイルパスのコレクションを返します。</returns>
        public static IEnumerable<StringPair> EnumerateEmitterNameAndTrimmingTexturePaths(this EmitterSetData emitterSetData)
        {
            return emitterSetData.AllActiveChildEmitters.SelectMany(x => x.EmitterNameAndTrimmingTexturePaths);
        }
    }
}
