﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectMaker.BusinessLogic.Options;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;

namespace EffectMaker.BusinessLogic.Commands
{
    /// <summary>
    /// SetOptionCommand
    /// </summary>
    [Alias("SetOption")]
    public class SetOptionCommand : CommandBase
    {
        /// <summary>元の値</summary>
        private object originalOptions = null;

        /// <summary>新しい値</summary>
        private object newOptions = null;

        /// <summary>コマンドの実行フラグ</summary>
        private bool doExecute = false;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public SetOptionCommand()
        {
            this.CanUndo = false;
        }

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        /// <param name="originalOptions">元の値</param>
        /// <param name="newOptions">新しい値</param>
        /// <param name="Execute">コマンドの実行フラグ</param>
        public SetOptionCommand(object originalOptions, object newOptions, bool doExecute)
            : this()
        {
            object[] args = new object[] { originalOptions, newOptions, doExecute };

            this.Initialize(args);
        }

        /// <summary>
        /// Initialize the command and process the arguments.
        /// </summary>
        /// <param name="args">The arguments for the command.</param>
        /// <returns>True on success.</returns>
        public override bool Initialize(object[] args)
        {
            if (args == null || args.Length != 3)
            {
                return false;
            }

            // パラメーターを取得
            this.originalOptions = args[0];
            this.newOptions = args[1];
            this.doExecute = (bool)args[2];

            this.IsInitialized = true;
            return true;
        }

        /// <summary>
        /// ターゲットを取得します.
        /// </summary>
        /// <returns>ターゲットのオブジェクトインスタンス</returns>
        public override object GetTarget()
        {
            return null;
        }

        /// <summary>
        /// Execute the command.
        /// </summary>
        /// <returns>True on success.</returns>
        public override bool Do()
        {
            if (this.doExecute)
            {
                // 新しい値をセットする
                OptionStore.RootOptions.Set(this.newOptions);
                OptionStore.TriggerOptionChangedEvent(null);
            }

            return true;
        }

        /// <summary>
        /// Undo the command.
        /// </summary>
        /// <returns>True on success.</returns>
        public override bool Undo()
        {
            // 元の値に戻す
            OptionStore.RootOptions.Set(this.originalOptions);

            return true;
        }

        /// <summary>
        /// Redo the command.
        /// </summary>
        /// <returns>True on success.</returns>
        public override bool Redo()
        {
            // 新しい値をセットする
            OptionStore.RootOptions.Set(this.newOptions);

            return true;
        }
    }
}
