﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.Foundation.Win32
{
    //---------------------------------------------------------------------
    // WinUser.h
    //---------------------------------------------------------------------
    #region WM
    /// <summary>
    /// Enumerator for windows messages.
    /// </summary>
    public enum WM
    {
        /// <summary>WM_NULL</summary>
        WM_NULL                   = 0x0000,

        /// <summary>WM_CREATE</summary>
        WM_CREATE                 = 0x0001,

        /// <summary>WM_DESTROY</summary>
        WM_DESTROY                = 0x0002,

        /// <summary>WM_MOVE</summary>
        WM_MOVE                   = 0x0003,

        /// <summary>WM_SIZE</summary>
        WM_SIZE                   = 0x0005,

        /// <summary>WM_ACTIVATE</summary>
        WM_ACTIVATE               = 0x0006,

        /// <summary>WM_SETFOCUS</summary>
        WM_SETFOCUS               = 0x0007,

        /// <summary>WM_KILLFOCUS</summary>
        WM_KILLFOCUS              = 0x0008,

        /// <summary>WM_ENABLE</summary>
        WM_ENABLE                 = 0x000A,

        /// <summary>WM_SETREDRAW</summary>
        WM_SETREDRAW              = 0x000B,

        /// <summary>WM_SETTEXT</summary>
        WM_SETTEXT                = 0x000C,

        /// <summary>WM_GETTEXT</summary>
        WM_GETTEXT                = 0x000D,

        /// <summary>WM_GETTEXTLENGTH</summary>
        WM_GETTEXTLENGTH          = 0x000E,

        /// <summary>WM_PAINT</summary>
        WM_PAINT                  = 0x000F,

        /// <summary>WM_CLOSE</summary>
        WM_CLOSE                  = 0x0010,

        /// <summary>WM_QUERYENDSESSION</summary>
        WM_QUERYENDSESSION        = 0x0011,

        /// <summary>WM_QUERYOPEN</summary>
        WM_QUERYOPEN              = 0x0013,

        /// <summary>WM_ENDSESSION</summary>
        WM_ENDSESSION             = 0x0016,

        /// <summary>WM_QUIT</summary>
        WM_QUIT                   = 0x0012,

        /// <summary>WM_ERASEBKGND</summary>
        WM_ERASEBKGND             = 0x0014,

        /// <summary>WM_SYSCOLORCHANGE</summary>
        WM_SYSCOLORCHANGE         = 0x0015,

        /// <summary>WM_SHOWWINDOW</summary>
        WM_SHOWWINDOW             = 0x0018,

        /// <summary>WM_CTLCOLOR</summary>
        WM_CTLCOLOR               = 0x0019,

        /// <summary>WM_WININICHANGE</summary>
        WM_WININICHANGE           = 0x001A,

        /// <summary>WM_SETTINGCHANGE</summary>
        WM_SETTINGCHANGE          = WM_WININICHANGE,

        /// <summary>WM_DEVMODECHANGE</summary>
        WM_DEVMODECHANGE          = 0x001B,

        /// <summary>WM_ACTIVATEAPP</summary>
        WM_ACTIVATEAPP            = 0x001C,

        /// <summary>WM_FONTCHANGE</summary>
        WM_FONTCHANGE             = 0x001D,

        /// <summary>WM_TIMECHANGE</summary>
        WM_TIMECHANGE             = 0x001E,

        /// <summary>WM_CANCELMODE</summary>
        WM_CANCELMODE             = 0x001F,

        /// <summary>WM_SETCURSOR</summary>
        WM_SETCURSOR              = 0x0020,

        /// <summary>WM_MOUSEACTIVATE</summary>
        WM_MOUSEACTIVATE          = 0x0021,

        /// <summary>WM_CHILDACTIVATE</summary>
        WM_CHILDACTIVATE          = 0x0022,

        /// <summary>WM_QUEUESYNC</summary>
        WM_QUEUESYNC              = 0x0023,

        /// <summary>WM_GETMINMAXINFO</summary>
        WM_GETMINMAXINFO          = 0x0024,

        /// <summary>WM_PAINTICON</summary>
        WM_PAINTICON              = 0x0026,

        /// <summary>WM_ICONERASEBKGND</summary>
        WM_ICONERASEBKGND         = 0x0027,

        /// <summary>WM_NEXTDLGCTL</summary>
        WM_NEXTDLGCTL             = 0x0028,

        /// <summary>WM_SPOOLERSTATUS</summary>
        WM_SPOOLERSTATUS          = 0x002A,

        /// <summary>WM_DRAWITEM</summary>
        WM_DRAWITEM               = 0x002B,

        /// <summary>WM_MEASUREITEM</summary>
        WM_MEASUREITEM            = 0x002C,

        /// <summary>WM_DELETEITEM</summary>
        WM_DELETEITEM             = 0x002D,

        /// <summary>WM_VKEYTOITEM</summary>
        WM_VKEYTOITEM             = 0x002E,

        /// <summary>WM_CHARTOITEM</summary>
        WM_CHARTOITEM             = 0x002F,

        /// <summary>WM_SETFONT</summary>
        WM_SETFONT                = 0x0030,

        /// <summary>WM_GETFONT</summary>
        WM_GETFONT                = 0x0031,

        /// <summary>WM_SETHOTKEY</summary>
        WM_SETHOTKEY              = 0x0032,

        /// <summary>WM_GETHOTKEY</summary>
        WM_GETHOTKEY              = 0x0033,

        /// <summary>WM_QUERYDRAGICON</summary>
        WM_QUERYDRAGICON          = 0x0037,

        /// <summary>WM_COMPAREITEM</summary>
        WM_COMPAREITEM            = 0x0039,

        /// <summary>WM_GETOBJECT</summary>
        WM_GETOBJECT              = 0x003D,

        /// <summary>WM_COMPACTING</summary>
        WM_COMPACTING             = 0x0041,

        /// <summary>WM_COMMNOTIFY</summary>
        WM_COMMNOTIFY             = 0x0044,

        /// <summary>WM_WINDOWPOSCHANGING</summary>
        WM_WINDOWPOSCHANGING      = 0x0046,

        /// <summary>WM_WINDOWPOSCHANGED</summary>
        WM_WINDOWPOSCHANGED       = 0x0047,

        /// <summary>WM_POWER</summary>
        WM_POWER                  = 0x0048,

        /// <summary>WM_COPYDATA</summary>
        WM_COPYDATA               = 0x004A,

        /// <summary>WM_CANCELJOURNAL</summary>
        WM_CANCELJOURNAL          = 0x004B,

        /// <summary>WM_NOTIFY</summary>
        WM_NOTIFY                 = 0x004E,

        /// <summary>WM_INPUTLANGCHANGEREQUEST</summary>
        WM_INPUTLANGCHANGEREQUEST = 0x0050,

        /// <summary>WM_INPUTLANGCHANGE</summary>
        WM_INPUTLANGCHANGE        = 0x0051,

        /// <summary>WM_TCARD</summary>
        WM_TCARD                  = 0x0052,

        /// <summary>WM_HELP</summary>
        WM_HELP                   = 0x0053,

        /// <summary>WM_USERCHANGED</summary>
        WM_USERCHANGED            = 0x0054,

        /// <summary>WM_NOTIFYFORMAT</summary>
        WM_NOTIFYFORMAT           = 0x0055,

        /// <summary>WM_CONTEXTMENU</summary>
        WM_CONTEXTMENU            = 0x007B,

        /// <summary>WM_STYLECHANGING</summary>
        WM_STYLECHANGING          = 0x007C,

        /// <summary>WM_STYLECHANGED</summary>
        WM_STYLECHANGED           = 0x007D,

        /// <summary>WM_DISPLAYCHANGE</summary>
        WM_DISPLAYCHANGE          = 0x007E,

        /// <summary>WM_GETICON</summary>
        WM_GETICON                = 0x007F,

        /// <summary>WM_SETICON</summary>
        WM_SETICON                = 0x0080,

        /// <summary>WM_NCCREATE</summary>
        WM_NCCREATE               = 0x0081,

        /// <summary>WM_NCDESTROY</summary>
        WM_NCDESTROY              = 0x0082,

        /// <summary>WM_NCCALCSIZE</summary>
        WM_NCCALCSIZE             = 0x0083,

        /// <summary>WM_NCHITTEST</summary>
        WM_NCHITTEST              = 0x0084,

        /// <summary>WM_NCPAINT</summary>
        WM_NCPAINT                = 0x0085,

        /// <summary>WM_NCACTIVATE</summary>
        WM_NCACTIVATE             = 0x0086,

        /// <summary>WM_GETDLGCODE</summary>
        WM_GETDLGCODE             = 0x0087,

        /// <summary>WM_SYNCPAINT</summary>
        WM_SYNCPAINT              = 0x0088,

        /// <summary>WM_NCMOUSEMOVE</summary>
        WM_NCMOUSEMOVE            = 0x00A0,

        /// <summary>WM_NCLBUTTONDOWN</summary>
        WM_NCLBUTTONDOWN          = 0x00A1,

        /// <summary>WM_NCLBUTTONUP</summary>
        WM_NCLBUTTONUP            = 0x00A2,

        /// <summary>WM_NCLBUTTONDBLCLK</summary>
        WM_NCLBUTTONDBLCLK        = 0x00A3,

        /// <summary>WM_NCRBUTTONDOWN</summary>
        WM_NCRBUTTONDOWN          = 0x00A4,

        /// <summary>WM_NCRBUTTONUP</summary>
        WM_NCRBUTTONUP            = 0x00A5,

        /// <summary>WM_NCRBUTTONDBLCLK</summary>
        WM_NCRBUTTONDBLCLK        = 0x00A6,

        /// <summary>WM_NCMBUTTONDOWN</summary>
        WM_NCMBUTTONDOWN          = 0x00A7,

        /// <summary>WM_NCMBUTTONUP</summary>
        WM_NCMBUTTONUP            = 0x00A8,

        /// <summary>WM_NCMBUTTONDBLCLK</summary>
        WM_NCMBUTTONDBLCLK        = 0x00A9,

        /// <summary>WM_NCXBUTTONDOWN</summary>
        WM_NCXBUTTONDOWN          = 0x00AB,

        /// <summary>WM_NCXBUTTONUP</summary>
        WM_NCXBUTTONUP            = 0x00AC,

        /// <summary>WM_NCXBUTTONDBLCLK</summary>
        WM_NCXBUTTONDBLCLK        = 0x00AD,

        /// <summary>WM_INPUT</summary>
        WM_INPUT                  = 0x00FF,

        /// <summary>WM_KEYFIRST</summary>
        WM_KEYFIRST               = 0x0100,

        /// <summary>WM_KEYDOWN</summary>
        WM_KEYDOWN                = 0x0100,

        /// <summary>WM_KEYUP</summary>
        WM_KEYUP                  = 0x0101,

        /// <summary>WM_CHAR</summary>
        WM_CHAR                   = 0x0102,

        /// <summary>WM_DEADCHAR</summary>
        WM_DEADCHAR               = 0x0103,

        /// <summary>WM_SYSKEYDOWN</summary>
        WM_SYSKEYDOWN             = 0x0104,

        /// <summary>WM_SYSKEYUP</summary>
        WM_SYSKEYUP               = 0x0105,

        /// <summary>WM_SYSCHAR</summary>
        WM_SYSCHAR                = 0x0106,

        /// <summary>WM_SYSDEADCHAR</summary>
        WM_SYSDEADCHAR            = 0x0107,

        /// <summary>WM_UNICHAR</summary>
        WM_UNICHAR                = 0x0109,

        /// <summary>WM_KEYLAST_forXPLater</summary>
        WM_KEYLAST_forXPLater     = 0x0109,

        /// <summary>WM_KEYLAST</summary>
        WM_KEYLAST                = 0x0108,

        /// <summary>WM_IME_STARTCOMPOSITION</summary>
        WM_IME_STARTCOMPOSITION   = 0x010D,

        /// <summary>WM_IME_ENDCOMPOSITION</summary>
        WM_IME_ENDCOMPOSITION     = 0x010E,

        /// <summary>WM_IME_COMPOSITION</summary>
        WM_IME_COMPOSITION        = 0x010F,

        /// <summary>WM_IME_KEYLAST</summary>
        WM_IME_KEYLAST            = 0x010F,

        /// <summary>WM_INITDIALOG</summary>
        WM_INITDIALOG             = 0x0110,

        /// <summary>WM_COMMAND</summary>
        WM_COMMAND                = 0x0111,

        /// <summary>WM_SYSCOMMAND</summary>
        WM_SYSCOMMAND             = 0x0112,

        /// <summary>WM_TIMER</summary>
        WM_TIMER                  = 0x0113,

        /// <summary>WM_HSCROLL</summary>
        WM_HSCROLL                = 0x0114,

        /// <summary>WM_VSCROLL</summary>
        WM_VSCROLL                = 0x0115,

        /// <summary>WM_INITMENU</summary>
        WM_INITMENU               = 0x0116,

        /// <summary>WM_INITMENUPOPUP</summary>
        WM_INITMENUPOPUP          = 0x0117,

        /// <summary>WM_MENUSELECT</summary>
        WM_MENUSELECT             = 0x011F,

        /// <summary>WM_MENUCHAR</summary>
        WM_MENUCHAR               = 0x0120,

        /// <summary>WM_ENTERIDLE</summary>
        WM_ENTERIDLE              = 0x0121,

        /// <summary>WM_MENURBUTTONUP</summary>
        WM_MENURBUTTONUP          = 0x0122,

        /// <summary>WM_MENUDRAG</summary>
        WM_MENUDRAG               = 0x0123,

        /// <summary>WM_MENUGETOBJECT</summary>
        WM_MENUGETOBJECT          = 0x0124,

        /// <summary>WM_UNINITMENUPOPUP</summary>
        WM_UNINITMENUPOPUP        = 0x0125,

        /// <summary>WM_MENUCOMMAND</summary>
        WM_MENUCOMMAND            = 0x0126,

        /// <summary>WM_CHANGEUISTATE</summary>
        WM_CHANGEUISTATE          = 0x0127,

        /// <summary>WM_UPDATEUISTATE</summary>
        WM_UPDATEUISTATE          = 0x0128,

        /// <summary>WM_QUERYUISTATE</summary>
        WM_QUERYUISTATE           = 0x0129,

        /// <summary>WM_CTLCOLORMSGBOX</summary>
        WM_CTLCOLORMSGBOX         = 0x0132,

        /// <summary>WM_CTLCOLOREDIT</summary>
        WM_CTLCOLOREDIT           = 0x0133,

        /// <summary>WM_CTLCOLORLISTBOX</summary>
        WM_CTLCOLORLISTBOX        = 0x0134,

        /// <summary>WM_CTLCOLORBTN</summary>
        WM_CTLCOLORBTN            = 0x0135,

        /// <summary>WM_CTLCOLORDLG</summary>
        WM_CTLCOLORDLG            = 0x0136,

        /// <summary>WM_CTLCOLORSCROLLBAR</summary>
        WM_CTLCOLORSCROLLBAR      = 0x0137,

        /// <summary>WM_CTLCOLORSTATIC</summary>
        WM_CTLCOLORSTATIC         = 0x0138,

        /// <summary>WM_MOUSEFIRST</summary>
        WM_MOUSEFIRST             = 0x0200,

        /// <summary>WM_MOUSEMOVE</summary>
        WM_MOUSEMOVE              = 0x0200,

        /// <summary>WM_LBUTTONDOWN</summary>
        WM_LBUTTONDOWN            = 0x0201,

        /// <summary>WM_LBUTTONUP</summary>
        WM_LBUTTONUP              = 0x0202,

        /// <summary>WM_LBUTTONDBLCLK</summary>
        WM_LBUTTONDBLCLK          = 0x0203,

        /// <summary>WM_RBUTTONDOWN</summary>
        WM_RBUTTONDOWN            = 0x0204,

        /// <summary>WM_RBUTTONUP</summary>
        WM_RBUTTONUP              = 0x0205,

        /// <summary>WM_RBUTTONDBLCLK</summary>
        WM_RBUTTONDBLCLK          = 0x0206,

        /// <summary>WM_MBUTTONDOWN</summary>
        WM_MBUTTONDOWN            = 0x0207,

        /// <summary>WM_MBUTTONUP</summary>
        WM_MBUTTONUP              = 0x0208,

        /// <summary>WM_MBUTTONDBLCLK</summary>
        WM_MBUTTONDBLCLK          = 0x0209,

        /// <summary>WM_MOUSEWHEEL</summary>
        WM_MOUSEWHEEL             = 0x020A,

        /// <summary>WM_XBUTTONDOWN</summary>
        WM_XBUTTONDOWN            = 0x020B,

        /// <summary>WM_XBUTTONUP</summary>
        WM_XBUTTONUP              = 0x020C,

        /// <summary>WM_XBUTTONDBLCLK</summary>
        WM_XBUTTONDBLCLK          = 0x020D,

        /// <summary>WM_MOUSELAST_for2KLater</summary>
        WM_MOUSELAST_for2KLater   = 0x020D,

        /// <summary>WM_MOUSELAST_forNT</summary>
        WM_MOUSELAST_forNT        = 0x020A,

        /// <summary>WM_MOUSELAST</summary>
        WM_MOUSELAST              = 0x0209,

        /// <summary>WM_PARENTNOTIFY</summary>
        WM_PARENTNOTIFY           = 0x0210,

        /// <summary>WM_ENTERMENULOOP</summary>
        WM_ENTERMENULOOP          = 0x0211,

        /// <summary>WM_EXITMENULOOP</summary>
        WM_EXITMENULOOP           = 0x0212,

        /// <summary>WM_NEXTMENU</summary>
        WM_NEXTMENU               = 0x0213,

        /// <summary>WM_SIZING</summary>
        WM_SIZING                 = 0x0214,

        /// <summary>WM_CAPTURECHANGED</summary>
        WM_CAPTURECHANGED         = 0x0215,

        /// <summary>WM_MOVING</summary>
        WM_MOVING                 = 0x0216,

        /// <summary>WM_POWERBROADCAST</summary>
        WM_POWERBROADCAST         = 0x0218,

        /// <summary>WM_DEVICECHANGE</summary>
        WM_DEVICECHANGE           = 0x0219,

        /// <summary>WM_MDICREATE</summary>
        WM_MDICREATE              = 0x0220,

        /// <summary>WM_MDIDESTROY</summary>
        WM_MDIDESTROY             = 0x0221,

        /// <summary>WM_MDIACTIVATE</summary>
        WM_MDIACTIVATE            = 0x0222,

        /// <summary>WM_MDIRESTORE</summary>
        WM_MDIRESTORE             = 0x0223,

        /// <summary>WM_MDINEXT</summary>
        WM_MDINEXT                = 0x0224,

        /// <summary>WM_MDIMAXIMIZE</summary>
        WM_MDIMAXIMIZE            = 0x0225,

        /// <summary>WM_MDITILE</summary>
        WM_MDITILE                = 0x0226,

        /// <summary>WM_MDICASCADE</summary>
        WM_MDICASCADE             = 0x0227,

        /// <summary>WM_MDIICONARRANGE</summary>
        WM_MDIICONARRANGE         = 0x0228,

        /// <summary>WM_MDIGETACTIVE</summary>
        WM_MDIGETACTIVE           = 0x0229,

        /// <summary>WM_MDISETMENU</summary>
        WM_MDISETMENU             = 0x0230,

        /// <summary>WM_ENTERSIZEMOVE</summary>
        WM_ENTERSIZEMOVE          = 0x0231,

        /// <summary>WM_EXITSIZEMOVE</summary>
        WM_EXITSIZEMOVE           = 0x0232,

        /// <summary>WM_DROPFILES</summary>
        WM_DROPFILES              = 0x0233,

        /// <summary>WM_MDIREFRESHMENU</summary>
        WM_MDIREFRESHMENU         = 0x0234,

        /// <summary>WM_IME_SETCONTEXT</summary>
        WM_IME_SETCONTEXT         = 0x0281,

        /// <summary>WM_IME_NOTIFY</summary>
        WM_IME_NOTIFY             = 0x0282,

        /// <summary>WM_IME_CONTROL</summary>
        WM_IME_CONTROL            = 0x0283,

        /// <summary>WM_IME_COMPOSITIONFULL</summary>
        WM_IME_COMPOSITIONFULL    = 0x0284,

        /// <summary>WM_IME_SELECT</summary>
        WM_IME_SELECT             = 0x0285,

        /// <summary>WM_IME_CHAR</summary>
        WM_IME_CHAR               = 0x0286,

        /// <summary>WM_IME_REQUEST</summary>
        WM_IME_REQUEST            = 0x0288,

        /// <summary>WM_IME_KEYDOWN</summary>
        WM_IME_KEYDOWN            = 0x0290,

        /// <summary>WM_IME_KEYUP</summary>
        WM_IME_KEYUP              = 0x0291,

        /// <summary>WM_MOUSEHOVER</summary>
        WM_MOUSEHOVER             = 0x02A1,

        /// <summary>WM_MOUSELEAVE</summary>
        WM_MOUSELEAVE             = 0x02A3,

        /// <summary>WM_NCMOUSEHOVER</summary>
        WM_NCMOUSEHOVER           = 0x02A0,

        /// <summary>WM_NCMOUSELEAVE</summary>
        WM_NCMOUSELEAVE           = 0x02A2,

        /// <summary>WM_WTSSESSION_CHANGE</summary>
        WM_WTSSESSION_CHANGE      = 0x02B1,

        /// <summary>WM_TABLET_FIRST</summary>
        WM_TABLET_FIRST           = 0x02c0,

        /// <summary>WM_TABLET_LAST</summary>
        WM_TABLET_LAST            = 0x02df,

        /// <summary>WM_CUT</summary>
        WM_CUT                    = 0x0300,

        /// <summary>WM_COPY</summary>
        WM_COPY                   = 0x0301,

        /// <summary>WM_PASTE</summary>
        WM_PASTE                  = 0x0302,

        /// <summary>WM_CLEAR</summary>
        WM_CLEAR                  = 0x0303,

        /// <summary>WM_UNDO</summary>
        WM_UNDO                   = 0x0304,

        /// <summary>WM_RENDERFORMAT</summary>
        WM_RENDERFORMAT           = 0x0305,

        /// <summary>WM_RENDERALLFORMATS</summary>
        WM_RENDERALLFORMATS       = 0x0306,

        /// <summary>WM_DESTROYCLIPBOARD</summary>
        WM_DESTROYCLIPBOARD       = 0x0307,

        /// <summary>WM_DRAWCLIPBOARD</summary>
        WM_DRAWCLIPBOARD          = 0x0308,

        /// <summary>WM_PAINTCLIPBOARD</summary>
        WM_PAINTCLIPBOARD         = 0x0309,

        /// <summary>WM_VSCROLLCLIPBOARD</summary>
        WM_VSCROLLCLIPBOARD       = 0x030A,

        /// <summary>WM_SIZECLIPBOARD</summary>
        WM_SIZECLIPBOARD          = 0x030B,

        /// <summary>WM_ASKCBFORMATNAME</summary>
        WM_ASKCBFORMATNAME        = 0x030C,

        /// <summary>WM_CHANGECBCHAIN</summary>
        WM_CHANGECBCHAIN          = 0x030D,

        /// <summary>WM_HSCROLLCLIPBOARD</summary>
        WM_HSCROLLCLIPBOARD       = 0x030E,

        /// <summary>WM_QUERYNEWPALETTE</summary>
        WM_QUERYNEWPALETTE        = 0x030F,

        /// <summary>WM_PALETTEISCHANGING</summary>
        WM_PALETTEISCHANGING      = 0x0310,

        /// <summary>WM_PALETTECHANGED</summary>
        WM_PALETTECHANGED         = 0x0311,

        /// <summary>WM_HOTKEY</summary>
        WM_HOTKEY                 = 0x0312,

        /// <summary>WM_PRINT</summary>
        WM_PRINT                  = 0x0317,

        /// <summary>WM_PRINTCLIENT</summary>
        WM_PRINTCLIENT            = 0x0318,

        /// <summary>WM_APPCOMMAND</summary>
        WM_APPCOMMAND             = 0x0319,

        /// <summary>WM_THEMECHANGED</summary>
        WM_THEMECHANGED           = 0x031A,

        /// <summary>WM_HANDHELDFIRST</summary>
        WM_HANDHELDFIRST          = 0x0358,

        /// <summary>WM_HANDHELDLAST</summary>
        WM_HANDHELDLAST           = 0x035F,

        /// <summary>WM_AFXFIRST</summary>
        WM_AFXFIRST               = 0x0360,

        /// <summary>WM_AFXLAST</summary>
        WM_AFXLAST                = 0x037F,

        /// <summary>WM_PENWINFIRST</summary>
        WM_PENWINFIRST            = 0x0380,

        /// <summary>WM_PENWINLAST</summary>
        WM_PENWINLAST             = 0x038F,

        /// <summary>WM_APP</summary>
        WM_APP                    = 0x8000,

        /// <summary>WM_USER</summary>
        WM_USER                   = 0x0400,

        /// <summary>WM_REFLECT</summary>
        WM_REFLECT                = 0x2000
    }
    #endregion

    #region VK
    /// <summary>
    /// Enumerator for virtual key codes.
    /// </summary>
    public enum VK
    {
        /// <summary>VK_LBUTTON</summary>
        VK_LBUTTON        = 0x01,

        /// <summary>VK_RBUTTON</summary>
        VK_RBUTTON        = 0x02,

        /// <summary>VK_CANCEL</summary>
        VK_CANCEL         = 0x03,

        /// <summary>VK_MBUTTON</summary>
        VK_MBUTTON        = 0x04,    /* NOT contiguous with L & RBUTTON */

        /// <summary>VK_XBUTTON1</summary>
        VK_XBUTTON1       = 0x05,    /* NOT contiguous with L & RBUTTON */

        /// <summary>VK_XBUTTON2</summary>
        VK_XBUTTON2       = 0x06,    /* NOT contiguous with L & RBUTTON */

        /// <summary>VK_BACK</summary>
        VK_BACK           = 0x08,

        /// <summary>VK_TAB</summary>
        VK_TAB            = 0x09,

        /// <summary>VK_CLEAR</summary>
        VK_CLEAR          = 0x0C,

        /// <summary>VK_RETURN</summary>
        VK_RETURN         = 0x0D,

        /// <summary>VK_SHIFT</summary>
        VK_SHIFT          = 0x10,

        /// <summary>VK_CONTROL</summary>
        VK_CONTROL        = 0x11,

        /// <summary>VK_MENU</summary>
        VK_MENU           = 0x12,

        /// <summary>VK_PAUSE</summary>
        VK_PAUSE          = 0x13,

        /// <summary>VK_CAPITAL</summary>
        VK_CAPITAL        = 0x14,

        /// <summary>VK_KANA</summary>
        VK_KANA           = 0x15,

        /// <summary>VK_HANGEUL</summary>
        VK_HANGEUL        = 0x15,  /* old name - should be here for compatibility */

        /// <summary>VK_HANGUL</summary>
        VK_HANGUL         = 0x15,

        /// <summary>VK_JUNJA</summary>
        VK_JUNJA          = 0x17,

        /// <summary>VK_FINAL</summary>
        VK_FINAL          = 0x18,

        /// <summary>VK_HANJA</summary>
        VK_HANJA          = 0x19,

        /// <summary>VK_KANJI</summary>
        VK_KANJI          = 0x19,

        /// <summary>VK_ESCAPE</summary>
        VK_ESCAPE         = 0x1B,

        /// <summary>VK_CONVERT</summary>
        VK_CONVERT        = 0x1C,

        /// <summary>VK_NONCONVERT</summary>
        VK_NONCONVERT     = 0x1D,

        /// <summary>VK_ACCEPT</summary>
        VK_ACCEPT         = 0x1E,

        /// <summary>VK_MODECHANGE</summary>
        VK_MODECHANGE     = 0x1F,

        /// <summary>VK_SPACE</summary>
        VK_SPACE          = 0x20,

        /// <summary>VK_PRIOR</summary>
        VK_PRIOR          = 0x21,

        /// <summary>VK_NEXT</summary>
        VK_NEXT           = 0x22,

        /// <summary>VK_END</summary>
        VK_END            = 0x23,

        /// <summary>VK_HOME</summary>
        VK_HOME           = 0x24,

        /// <summary>VK_LEFT</summary>
        VK_LEFT           = 0x25,

        /// <summary>VK_UP</summary>
        VK_UP             = 0x26,

        /// <summary>VK_RIGHT</summary>
        VK_RIGHT          = 0x27,

        /// <summary>VK_DOWN</summary>
        VK_DOWN           = 0x28,

        /// <summary>VK_SELECT</summary>
        VK_SELECT         = 0x29,

        /// <summary>VK_PRINT</summary>
        VK_PRINT          = 0x2A,

        /// <summary>VK_EXECUTE</summary>
        VK_EXECUTE        = 0x2B,

        /// <summary>VK_SNAPSHOT</summary>
        VK_SNAPSHOT       = 0x2C,

        /// <summary>VK_INSERT</summary>
        VK_INSERT         = 0x2D,

        /// <summary>VK_DELETE</summary>
        VK_DELETE         = 0x2E,

        /// <summary>VK_HELP</summary>
        VK_HELP           = 0x2F,

        /// <summary>VK_LWIN</summary>
        VK_LWIN           = 0x5B,

        /// <summary>VK_RWIN</summary>
        VK_RWIN           = 0x5C,

        /// <summary>VK_APPS</summary>
        VK_APPS           = 0x5D,

        /// <summary>VK_SLEEP</summary>
        VK_SLEEP          = 0x5F,

        /// <summary>VK_NUMPAD0</summary>
        VK_NUMPAD0        = 0x60,

        /// <summary>VK_NUMPAD1</summary>
        VK_NUMPAD1        = 0x61,

        /// <summary>VK_NUMPAD2</summary>
        VK_NUMPAD2        = 0x62,

        /// <summary>VK_NUMPAD3</summary>
        VK_NUMPAD3        = 0x63,

        /// <summary>VK_NUMPAD4</summary>
        VK_NUMPAD4        = 0x64,

        /// <summary>VK_NUMPAD5</summary>
        VK_NUMPAD5        = 0x65,

        /// <summary>VK_NUMPAD6</summary>
        VK_NUMPAD6        = 0x66,

        /// <summary>VK_NUMPAD7</summary>
        VK_NUMPAD7        = 0x67,

        /// <summary>VK_NUMPAD8</summary>
        VK_NUMPAD8        = 0x68,

        /// <summary>VK_NUMPAD9</summary>
        VK_NUMPAD9        = 0x69,

        /// <summary>VK_MULTIPLY</summary>
        VK_MULTIPLY       = 0x6A,

        /// <summary>VK_ADD</summary>
        VK_ADD            = 0x6B,

        /// <summary>VK_SEPARATOR</summary>
        VK_SEPARATOR      = 0x6C,

        /// <summary>VK_SUBTRACT</summary>
        VK_SUBTRACT       = 0x6D,

        /// <summary>VK_DECIMAL</summary>
        VK_DECIMAL        = 0x6E,

        /// <summary>VK_DIVIDE</summary>
        VK_DIVIDE         = 0x6F,

        /// <summary>VK_F1</summary>
        VK_F1             = 0x70,

        /// <summary>VK_F2</summary>
        VK_F2             = 0x71,

        /// <summary>VK_F3</summary>
        VK_F3             = 0x72,

        /// <summary>VK_F4</summary>
        VK_F4             = 0x73,

        /// <summary>VK_F5</summary>
        VK_F5             = 0x74,

        /// <summary>VK_F6</summary>
        VK_F6             = 0x75,

        /// <summary>VK_F7</summary>
        VK_F7             = 0x76,

        /// <summary>VK_F8</summary>
        VK_F8             = 0x77,

        /// <summary>VK_F9</summary>
        VK_F9             = 0x78,

        /// <summary>VK_F10</summary>
        VK_F10            = 0x79,

        /// <summary>VK_F11</summary>
        VK_F11            = 0x7A,

        /// <summary>VK_F12</summary>
        VK_F12            = 0x7B,

        /// <summary>VK_F13</summary>
        VK_F13            = 0x7C,

        /// <summary>VK_F14</summary>
        VK_F14            = 0x7D,

        /// <summary>VK_F15</summary>
        VK_F15            = 0x7E,

        /// <summary>VK_F16</summary>
        VK_F16            = 0x7F,

        /// <summary>VK_F17</summary>
        VK_F17            = 0x80,

        /// <summary>VK_F18</summary>
        VK_F18            = 0x81,

        /// <summary>VK_F19</summary>
        VK_F19            = 0x82,

        /// <summary>VK_F20</summary>
        VK_F20            = 0x83,

        /// <summary>VK_F21</summary>
        VK_F21            = 0x84,

        /// <summary>VK_F22</summary>
        VK_F22            = 0x85,

        /// <summary>VK_F23</summary>
        VK_F23            = 0x86,

        /// <summary>VK_F24</summary>
        VK_F24            = 0x87,

        /// <summary>VK_NUMLOCK</summary>
        VK_NUMLOCK        = 0x90,

        /// <summary>VK_SCROLL</summary>
        VK_SCROLL         = 0x91,

        /// <summary>VK_OEM_NEC_EQUAL</summary>
        VK_OEM_NEC_EQUAL  = 0x92,   // '=' key on numpad

        /// <summary>VK_OEM_FJ_JISHO</summary>
        VK_OEM_FJ_JISHO   = 0x92,   // 'Dictionary' key

        /// <summary>VK_OEM_FJ_MASSHOU</summary>
        VK_OEM_FJ_MASSHOU = 0x93,   // 'Unregister word' key

        /// <summary>VK_OEM_FJ_TOUROKU</summary>
        VK_OEM_FJ_TOUROKU = 0x94,   // 'Register word' key

        /// <summary>VK_OEM_FJ_LOYA</summary>
        VK_OEM_FJ_LOYA    = 0x95,   // 'Left OYAYUBI' key

        /// <summary>VK_OEM_FJ_ROYA</summary>
        VK_OEM_FJ_ROYA    = 0x96,   // 'Right OYAYUBI' key

        /// <summary>VK_LSHIFT</summary>
        VK_LSHIFT         = 0xA0,

        /// <summary>VK_RSHIFT</summary>
        VK_RSHIFT         = 0xA1,

        /// <summary>VK_LCONTROL</summary>
        VK_LCONTROL       = 0xA2,

        /// <summary>VK_RCONTROL</summary>
        VK_RCONTROL       = 0xA3,

        /// <summary>VK_LMENU</summary>
        VK_LMENU          = 0xA4,

        /// <summary>VK_RMENU</summary>
        VK_RMENU          = 0xA5,

        /// <summary>VK_BROWSER_BACK</summary>
        VK_BROWSER_BACK        = 0xA6,

        /// <summary>VK_BROWSER_FORWARD</summary>
        VK_BROWSER_FORWARD     = 0xA7,

        /// <summary>VK_BROWSER_REFRESH</summary>
        VK_BROWSER_REFRESH     = 0xA8,

        /// <summary>VK_BROWSER_STOP</summary>
        VK_BROWSER_STOP        = 0xA9,

        /// <summary>VK_BROWSER_SEARCH</summary>
        VK_BROWSER_SEARCH      = 0xAA,

        /// <summary>VK_BROWSER_FAVORITES</summary>
        VK_BROWSER_FAVORITES   = 0xAB,

        /// <summary>VK_BROWSER_HOME</summary>
        VK_BROWSER_HOME        = 0xAC,

        /// <summary>VK_VOLUME_MUTE</summary>
        VK_VOLUME_MUTE         = 0xAD,

        /// <summary>VK_VOLUME_DOWN</summary>
        VK_VOLUME_DOWN         = 0xAE,

        /// <summary>VK_VOLUME_UP</summary>
        VK_VOLUME_UP           = 0xAF,

        /// <summary>VK_MEDIA_NEXT_TRACK</summary>
        VK_MEDIA_NEXT_TRACK    = 0xB0,

        /// <summary>VK_MEDIA_PREV_TRACK</summary>
        VK_MEDIA_PREV_TRACK    = 0xB1,

        /// <summary>VK_MEDIA_STOP</summary>
        VK_MEDIA_STOP          = 0xB2,

        /// <summary>VK_MEDIA_PLAY_PAUSE</summary>
        VK_MEDIA_PLAY_PAUSE    = 0xB3,

        /// <summary>VK_LAUNCH_MAIL</summary>
        VK_LAUNCH_MAIL         = 0xB4,

        /// <summary>VK_LAUNCH_MEDIA_SELECT</summary>
        VK_LAUNCH_MEDIA_SELECT = 0xB5,

        /// <summary>VK_LAUNCH_APP1</summary>
        VK_LAUNCH_APP1         = 0xB6,

        /// <summary>VK_LAUNCH_APP2</summary>
        VK_LAUNCH_APP2         = 0xB7,

        /// <summary>VK_OEM_1</summary>
        VK_OEM_1          = 0xBA,   // ',:' for US

        /// <summary>VK_OEM_PLUS</summary>
        VK_OEM_PLUS       = 0xBB,   // '+' any country

        /// <summary>VK_OEM_COMMA</summary>
        VK_OEM_COMMA      = 0xBC,   // ',' any country

        /// <summary>VK_OEM_MINUS</summary>
        VK_OEM_MINUS      = 0xBD,   // '-' any country

        /// <summary>VK_OEM_PERIOD</summary>
        VK_OEM_PERIOD     = 0xBE,   // '.' any country

        /// <summary>VK_OEM_2</summary>
        VK_OEM_2          = 0xBF,   // '/?' for US

        /// <summary>VK_OEM_3</summary>
        VK_OEM_3          = 0xC0,   // '`~' for US

        /// <summary>VK_OEM_4</summary>
        VK_OEM_4          = 0xDB,  // '[{' for US

        /// <summary>VK_OEM_5</summary>
        VK_OEM_5          = 0xDC,  // '\|' for US

        /// <summary>VK_OEM_6</summary>
        VK_OEM_6          = 0xDD,  // ']}' for US

        /// <summary>VK_OEM_7</summary>
        VK_OEM_7          = 0xDE,  // ''"' for US

        /// <summary>VK_OEM_8</summary>
        VK_OEM_8          = 0xDF,

        /// <summary>VK_OEM_AX</summary>
        VK_OEM_AX         = 0xE1,  // 'AX' key on Japanese AX kbd

        /// <summary>VK_OEM_102</summary>
        VK_OEM_102        = 0xE2,  // "<>" or "\|" on RT 102-key kbd.

        /// <summary>VK_ICO_HELP</summary>
        VK_ICO_HELP       = 0xE3,  // Help key on ICO

        /// <summary>VK_ICO_00</summary>
        VK_ICO_00         = 0xE4,  // 00 key on ICO

        /// <summary>VK_PROCESSKEY</summary>
        VK_PROCESSKEY     = 0xE5,

        /// <summary>VK_ICO_CLEAR</summary>
        VK_ICO_CLEAR      = 0xE6,

        /// <summary>VK_PACKET</summary>
        VK_PACKET         = 0xE7,

        /// <summary>VK_OEM_RESET</summary>
        VK_OEM_RESET      = 0xE9,

        /// <summary>VK_OEM_JUMP</summary>
        VK_OEM_JUMP       = 0xEA,

        /// <summary>VK_OEM_PA1</summary>
        VK_OEM_PA1        = 0xEB,

        /// <summary>VK_OEM_PA2</summary>
        VK_OEM_PA2        = 0xEC,

        /// <summary>VK_OEM_PA3</summary>
        VK_OEM_PA3        = 0xED,

        /// <summary>VK_OEM_WSCTRL</summary>
        VK_OEM_WSCTRL     = 0xEE,

        /// <summary>VK_OEM_CUSEL</summary>
        VK_OEM_CUSEL      = 0xEF,

        /// <summary>VK_OEM_ATTN</summary>
        VK_OEM_ATTN       = 0xF0,

        /// <summary>VK_OEM_FINISH</summary>
        VK_OEM_FINISH     = 0xF1,

        /// <summary>VK_OEM_COPY</summary>
        VK_OEM_COPY       = 0xF2,

        /// <summary>VK_OEM_AUTO</summary>
        VK_OEM_AUTO       = 0xF3,

        /// <summary>VK_OEM_ENLW</summary>
        VK_OEM_ENLW       = 0xF4,

        /// <summary>VK_OEM_BACKTAB</summary>
        VK_OEM_BACKTAB    = 0xF5,

        /// <summary>VK_ATTN</summary>
        VK_ATTN           = 0xF6,

        /// <summary>VK_CRSEL</summary>
        VK_CRSEL          = 0xF7,

        /// <summary>VK_EXSEL</summary>
        VK_EXSEL          = 0xF8,

        /// <summary>VK_EREOF</summary>
        VK_EREOF          = 0xF9,

        /// <summary>VK_PLAY</summary>
        VK_PLAY           = 0xFA,

        /// <summary>VK_ZOOM</summary>
        VK_ZOOM           = 0xFB,

        /// <summary>VK_NONAME</summary>
        VK_NONAME         = 0xFC,

        /// <summary>VK_PA1</summary>
        VK_PA1            = 0xFD,

        /// <summary>VK_OEM_CLEAR</summary>
        VK_OEM_CLEAR      = 0xFE
    }
    #endregion

    //---------------------------------------------------------------------
    // CommCtrl.h
    //---------------------------------------------------------------------
    #region TB
    /// <summary>
    /// Enumerator for track bar commands.
    /// </summary>
    public enum TB
    {
        /// <summary>TB_LINEUP</summary>
        TB_LINEUP               = 0,

        /// <summary>TB_LINEDOWN</summary>
        TB_LINEDOWN             = 1,

        /// <summary>TB_PAGEUP</summary>
        TB_PAGEUP               = 2,

        /// <summary>TB_PAGEDOWN</summary>
        TB_PAGEDOWN             = 3,

        /// <summary>TB_THUMBPOSITION</summary>
        TB_THUMBPOSITION        = 4,

        /// <summary>TB_THUMBTRACK</summary>
        TB_THUMBTRACK           = 5,

        /// <summary>TB_TOP</summary>
        TB_TOP                  = 6,

        /// <summary>TB_BOTTOM</summary>
        TB_BOTTOM               = 7,

        /// <summary>TB_ENDTRACK</summary>
        TB_ENDTRACK             = 8
    }
    #endregion
}
