﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.Foundation.Texture
{
    /// <summary>
    /// The tile mode the textures use.
    /// </summary>
    public enum TextureTileModes : uint
    {
        /// <summary>Default, no tiling.</summary>
        Default = 0x00000000,

        /// <summary>nw.g3d.nw4f_3dif.texture_info_tile_modeType.linear_aligned</summary>
        LinearAligned = 0x00000001,

        /// <summary>nw.g3d.nw4f_3dif.texture_info_tile_modeType.Item1d_tiled_thin1</summary>
        Tiled1DThin1 = 0x00000002,

        /// <summary>nw.g3d.nw4f_3dif.texture_info_tile_modeType.Item1d_tiled_thick</summary>
        Tiled1DThick = 0x00000003,

        /// <summary>nw.g3d.nw4f_3dif.texture_info_tile_modeType.Item2d_tiled_thin1</summary>
        Tiled2DThin1 = 0x00000004,

        /// <summary>nw.g3d.nw4f_3dif.texture_info_tile_modeType.Item2d_tiled_thin2</summary>
        Tiled2DThin2 = 0x00000005,

        /// <summary>nw.g3d.nw4f_3dif.texture_info_tile_modeType.Item2d_tiled_thin4</summary>
        Tiled2DThin4 = 0x00000006,

        /// <summary>nw.g3d.nw4f_3dif.texture_info_tile_modeType.Item2d_tiled_thick</summary>
        Tiled2DThick = 0x00000007,

        /// <summary>nw.g3d.nw4f_3dif.texture_info_tile_modeType.Item2b_tiled_thin1</summary>
        Tiled2BThin1 = 0x00000008,

        /// <summary>nw.g3d.nw4f_3dif.texture_info_tile_modeType.Item2b_tiled_thin2</summary>
        Tiled2BThin2 = 0x00000009,

        /// <summary>nw.g3d.nw4f_3dif.texture_info_tile_modeType.Item2b_tiled_thin4</summary>
        Tiled2BThin4 = 0x0000000A,

        /// <summary>nw.g3d.nw4f_3dif.texture_info_tile_modeType.Item2b_tiled_thick</summary>
        Tiled2BThick = 0x0000000B,

        /// <summary>nw.g3d.nw4f_3dif.texture_info_tile_modeType.Item3d_tiled_thin1</summary>
        Tiled3DThin1 = 0x0000000C,

        /// <summary>nw.g3d.nw4f_3dif.texture_info_tile_modeType.Item3d_tiled_thick</summary>
        Tiled3DThick = 0x0000000D,

        /// <summary>nw.g3d.nw4f_3dif.texture_info_tile_modeType.Item3b_tiled_thin1</summary>
        Tiled3BThin1 = 0x0000000E,

        /// <summary>nw.g3d.nw4f_3dif.texture_info_tile_modeType.Item3b_tiled_thick</summary>
        Tiled3BThick = 0x0000000F,
    }
}
