﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.Foundation.Texture
{
    /// <summary>
    /// テクスチャを読み込んだときのリザルトコードです。
    /// </summary>
    public enum LoadTextureResultCode
    {
        /// <summary>
        /// 成功
        /// </summary>
        Success,

        /// <summary>
        /// ファイルが見つからない
        /// </summary>
        FileNotFound,

        /// <summary>
        /// 未定義のテクスチャタイプ
        /// </summary>
        UnknowTextureType,

        /// <summary>
        /// テクスチャの読み込みに失敗
        /// </summary>
        FailedLoadingTexture,

        /// <summary>
        /// ファイルバージョンが不正
        /// </summary>
        InvalidFileVersion,
    }

    /// <summary>
    /// テクスチャの読み込み結果です。
    /// </summary>
    public class LoadTextureResult
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public LoadTextureResult()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="resultCode">リザルトコード</param>
        public LoadTextureResult(LoadTextureResultCode resultCode)
        {
            this.ResultCode = resultCode;
        }

        /// <summary>
        /// リザルトコードを取得または設定します。
        /// </summary>
        public LoadTextureResultCode ResultCode { get; set; }

        /// <summary>
        /// テクスチャデータを取得または設定します。
        /// </summary>
        public TextureData TextureData { get; set; }
    }
}
