﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.Foundation.Extensions
{
    /// <summary>
    /// Extensions methods related to the PropertyInfo class.
    /// </summary>
    public static class PropertyInfoExtensions
    {
        /// <summary>
        /// Tells whether the property can be publicly read.
        /// </summary>
        /// <param name="propertyInfo">The property to check.</param>
        /// <returns>Returns true if the property can be publicly read,
        /// false otherwise.</returns>
        public static bool CanPubliclyRead(this PropertyInfo propertyInfo)
        {
            if (propertyInfo == null)
            {
                throw new ArgumentNullException("propertyInfo");
            }

            return propertyInfo.GetGetMethod(false) != null;
        }

        /// <summary>
        /// Tells whether the property can be publicly written.
        /// </summary>
        /// <param name="propertyInfo">The property to check.</param>
        /// <returns>Returns true if the property can be publicly written,
        /// false otherwise.</returns>
        public static bool CanPubliclyWrite(this PropertyInfo propertyInfo)
        {
            if (propertyInfo == null)
            {
                throw new ArgumentNullException("propertyInfo");
            }

            return propertyInfo.GetSetMethod(false) != null;
        }
    }
}
