﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;

namespace EffectMaker.Foundation.Debugging.Profiling
{
    /// <summary>
    /// Represent a code instrumenation mechanism.
    /// </summary>
    public interface IInstrumentation : IDisposable
    {
        /// <summary>
        /// Gets the instrumentation steps.
        /// </summary>
        IEnumerable<IInstrumentationStepInfo> Steps { get; }

        /// <summary>
        /// Restarts the instrumentation.
        /// </summary>
        void Restart();

        /// <summary>
        /// Record a step of the instrumentation.
        /// </summary>
        /// <param name="stepDescription">The name of the current step to record.</param>
        void Step(string stepDescription);

        /// <summary>
        /// Accumulate a step for the given description.
        /// </summary>
        /// <param name="stepDescription">The name of the current step to record.</param>
        void Accumulate(string stepDescription);
    }
}
