﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.Foundation.Editting;

namespace EffectMaker.Foundation.ClipboardDataTypes
{
    /// <summary>
    /// 色単位クリップボードデータ
    /// </summary>
    [Serializable]
    public class ColorUnitClipboardData
    {
        /// <summary>
        /// クリップボードフォーマット
        /// </summary>
        public static readonly string ClipboardFormat = typeof(ColorUnitClipboardData).ToString();

        /// <summary>
        /// 対象
        /// </summary>
        public ColorTargetType Target { get; set; }

        /// <summary>
        /// コピーデータ本体
        /// </summary>
        public string Body { get; set; }
    }
}
