﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.Foundation.Attributes
{
    /// <summary>
    /// An attribute that decorate classes with a display order information.
    /// </summary>
    [AttributeUsage(AttributeTargets.Class, AllowMultiple = false, Inherited = false)]
    public class DisplayOrderAttribute : Attribute
    {
        /// <summary>
        /// Initializes the DisplayOrderAttribute instance.
        /// </summary>
        /// <param name="value">The display order number.</param>
        public DisplayOrderAttribute(int value)
        {
            this.Value = value;
        }

        /// <summary>
        /// Gets the display order.
        /// </summary>
        public int Value { get; private set; }
    }
}
