﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShaderCompileErrorInfo_H__
#define __ShaderCompileErrorInfo_H__


using namespace System;
using namespace System::Collections::Generic;


namespace EffectMaker {
namespace ShaderConverterWrapper {

/// <summary>
/// Data class that holds shader compile error information.
/// </summary>
public ref class ShaderCompileErrorInfo
{
public :
    /// <summary>
    /// Constructor.
    /// </summary>
    /// <param name="isWarning">The flag indicating whether if this is only a warning.</param>
    /// <param name="szEmitterName">The emitter name for the shader.</param>
    /// <param name="szVertexShader">The vertex shader source code.</param>
    /// <param name="szFragmentShader">The fragment shader source code.</param>
    /// <param name="szErrorLog">The error log generated by the compiler.</param>
    ShaderCompileErrorInfo(bool isWarning,
                           const char *szEmitterName,
                           const char *szVertexShader,
                           const char *szFragmentShader,
                           const char *szErrorLog)
    {
        this->IsWarning      = isWarning;
        this->EmitterName    = gcnew String(szEmitterName);
        this->VertexShader   = gcnew String(szVertexShader);
        this->FragmentShader = gcnew String(szFragmentShader);
        this->ErrorLog       = gcnew String(szErrorLog);
    };

    /// <summary>
    /// Get or set the flag indicating whether if this is just a warning, or error.
    /// </summary>
    property bool IsWarning;

    /// <summary>
    /// Get or set the emitter name.
    /// </summary>
    property String^ EmitterName;

    /// <summary>
    /// Get or set the vertex shader that failed the compile.
    /// </summary>
    property String^ VertexShader;

    /// <summary>
    /// Get or set the fragment shader that failed the compile.
    /// </summary>
    property String^ FragmentShader;

    /// <summary>
    /// Get or set the error log generated by the shader compiler.
    /// </summary>
    property String^ ErrorLog;
};

} // namespace ShaderConverterWrapper
} // namespace EffectMaker


#endif // __ShaderCompileErrorInfo_H__
