﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __DotNetMessage_H__
#define __DotNetMessage_H__


using namespace System;
using namespace System::Collections::Generic;

using namespace EffectMaker::ShaderConverterLib;


namespace EffectMaker {
namespace ShaderConverterWrapper {

    /// <summary>
    /// The message data class for application. (.NET interface)
    /// </summary>
    public ref class DotNetMessage
    {
    public :
        /// <summary>
        /// Static constructor.
        /// </summary>
        static DotNetMessage()
        {
            s_delimiters = gcnew array<Char> { ',', ' ', '\r', '\n' };
        };

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="pMessage">The native message data from the shader converter.</param>
        DotNetMessage(const MessageBase *pMessage);

        /// <summary>
        /// Get the name of the message.
        /// </summary>
        property String^ Name
        {
            String^ get() { return m_name; }
        }

        /// <summary>
        /// Get the arguments of the message.
        /// </summary>
        property array<String^>^ Arguments
        {
            initonly array<String^>^ get() { return m_pArguments; }
        }

        /// <summary>
        /// Get argument value of the message.
        /// </summary>
        /// <param name="argName">The name of the argument.</param>
        String^ GetArg(String ^argName);

    private :
        static initonly array<Char> ^s_delimiters;

        String ^m_name;

        array<String^>           ^m_pArguments;
        Dictionary<String^, int> ^m_pArgNameMap;
    };

} // namespace ShaderConverterWrapper
} // namespace EffectMaker

#endif // __DotNetMessage_H__
