﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// BinaryConvertUtils.h

#pragma once

using namespace System;
using namespace System::IO;


namespace BinaryConvertUtils {

    public ref class BinaryConverter
    {
    public:
        enum class errCode : int
        {
            noErr = 0,
            notInitialize = 1,
            SetOptions = 2,
            AddFile = 3,
            CalcSize = 4,
            MallocOutBuf = 5,
            Convert = 6,
            Bind = 7,
            EndianSwap = 8,
            SaveFile = 9,
            UnknownErr = 10,
        };

    public:
        BinaryConverter();
        // TODO: このクラスの、ユーザーのメソッドをここに追加してください。

        bool Initialize( System::String^ baseFolder,
                         bool flg64bit );
        void Destroy();

        // バイナリコンバートで利用するオプションを指定し、プリバイナライズを行う
        int PreBinarize(const wchar_t** options);

        // --viewerオプションを利用して、プリバイナライズを行う
        int PreBinarizeUsingViewerOption();

        // --ignore-assignオプションを利用して、プリバイナライズを行う
        int PreBinarizeUsingIgnoreAssignOption();

        // 3dBinaryConverterにオプションを指定して、ファイルを追加する
        int AddFile( array<Byte>^ pInputStreamBuf,
                     int inputSize,
                     String^ filePath,
                     String^ name,
                     String^ ext );

        // fmdbファイルのリソースとして、3dBinaryConverterにファイルを追加する
        int AddExternalFile( array<Byte>^ pInputStreamBuf,
                             int inputSize,
                             String^ filePath,
                             String^ name,
                             String^ ext,
                             int alignment );

        // バイナリコンバートを行い、結果をストリームに出力する
        int Binarize( Stream^ stream );

        //-----------------------------------------------------------------------------
        // In 3dBinaryConverter.dll, they might changed the floating point control modes
        // and set the precision control to use the lowest (24 bits) precision.
        // We need to keep NW4F and CE2 build consistent, and since we don't need such
        // high precision, we set it to the low precision control mode for CE2 build.
        //-----------------------------------------------------------------------------
        static void SetupFloatControlMode();

    private:
        bool isInitialized_;
        HINSTANCE hDLL_;

        typedef long (*FUNC_GetCvtrVersion)();
        typedef bool (*FUNC_Initialize)();
        typedef void (*FUNC_Clear)();
        typedef bool (*FUNC_Shutdown)();
        typedef bool (*FUNC_SetOptions)(const wchar_t*[]);
        typedef bool (*FUNC_AddFile)(const void*, size_t, const wchar_t*[], const wchar_t*[]);
        typedef size_t (*FUNC_CalcSize)();
        typedef bool (*FUNC_Convert)(void*, size_t);
        typedef bool (*FUNC_Bind)(void*, size_t);
        typedef bool (*FUNC_EndianSwap)(void*, size_t);

        FUNC_GetCvtrVersion GetCvtrVersion_;
        FUNC_Initialize     Initialize_;
        FUNC_Clear			Clear_;
        FUNC_Shutdown		Shutdown_;
        FUNC_SetOptions		SetOptions_;
        FUNC_AddFile		AddFile_;
        FUNC_CalcSize		CalcSize_;
        FUNC_Convert		Convert_;
        FUNC_Bind			Bind_;
        FUNC_EndianSwap		EndianSwap_;

        int AddFileInternal( array<Byte>^ pInputStreamBuf,
                             int inputSize,
                             String^ filePath,
                             String^ name,
                             String^ ext,
                             array<String^>^ options);

        bool SaveFile( const char* outData,
                       size_t outSize,
                       const wchar_t* path );
    };

}
