﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using EffectMaker.Application.OptionPanes;

namespace EffectMaker.Application
{
    /// <summary>
    /// An extended TreeNode class that represent an IOptionPane instance.
    /// </summary>
    public class OptionPaneTreeViewItem : TreeNode, IDisposable
    {
        /// <summary>
        /// Initializes the OptionPaneTreeViewItem instance.
        /// </summary>
        /// <param name="optionPane">The instance of IOptionPane to represent.</param>
        public OptionPaneTreeViewItem(IOptionPane optionPane)
        {
            if (optionPane == null)
            {
                throw new ArgumentNullException("optionPane");
            }

            this.OptionPane = optionPane;
            this.Text = optionPane.DisplayName;
        }

        /// <summary>
        /// Gets the represented IOptionPane instance.
        /// </summary>
        public IOptionPane OptionPane { get; private set; }

        /// <summary>
        /// Disposes the instance and terminate the IOptionPane.
        /// </summary>
        public void Dispose()
        {
            this.OptionPane.OnTerminate();
        }

        /// <summary>
        /// paneの入力項目が正常かどうか返す。
        /// </summary>
        /// <returns>正常ならtrueを、不正な入力項目がある場合はfalseを返す。</returns>
        public bool Validate()
        {
            return this.OptionPane.OnValidationCheck();
        }
    }
}
