﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

// 新しいタブデザインを利用する
// コメントアウトすれば、今までのデザインが利用される。
#define REMAKE_TAB

using System.Drawing;
using System.Windows.Forms;

using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.Extensions;

using EffectMaker.UIControls.Specifics.TabPages;

namespace EffectMaker.Application
{
    /// <summary>
    /// プロパティパネル
    /// </summary>
#if REMAKE_TAB
    public class PropertyPanel : UIRemakeTab
#else
    public class PropertyPanel : UITabControl
#endif // REMAKE_TAB
   {
        /// <summary>
        /// Constructor.
        /// </summary>
        public PropertyPanel() :
            base()
        {
#if REMAKE_TAB
            // テーマが有効な場合はサイズを調整する
            if (Foundation.Win32.Utility.IsThemeActive)
            {
                this.ItemSize = new Size(67, 21);
            }
#endif // REMAKE_TAB

            this.AddBinding("ItemsSource", "Children");
            this.AddBinding("SelectedItem", "SelectedPropertyPage");
        }

        /// <summary>
        /// コマンド キーを処理します。
        /// </summary>
        /// <returns>
        /// 文字がコントロールによって処理された場合は true。それ以外の場合は false。
        /// </returns>
        /// <param name="msg">処理するウィンドウ メッセージを表す、参照渡しされた <see cref="T:System.Windows.Forms.Message"/>。</param>
        /// <param name="keyData">処理するキーを表す <see cref="T:System.Windows.Forms.Keys"/> 値の 1 つ。</param>
        protected override bool ProcessCmdKey(ref Message msg, Keys keyData)
        {
            if (keyData == Keys.Tab)
            {
                var page = this.SelectedTab as PropertyTabPageBase;
                if (page != null)
                {
                    page.SelectFirstChildControl(true);
                }

                return true;
            }
            else if (keyData == (Keys.Tab | Keys.Shift))
            {
                var page = this.SelectedTab as PropertyTabPageBase;
                if (page != null)
                {
                    page.SelectFirstChildControl(false);
                }

                return true;
            }
            else
            {
                return base.ProcessCmdKey(ref msg, keyData);
            }
        }
    }
}
