﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Windows.Forms;

namespace EffectMaker.Application
{
    /// <summary>
    /// 非アクティブ状態から1回のクリックで反応させるための実装を行ったMenuStripクラス.
    /// </summary>
    public class MainFormMenuStrip : MenuStrip
    {
        /// <summary>
        /// 非アクティブ状態から1回のクリックで反応させるためのオーバーライド
        /// </summary>
        /// <param name="m">ウィンドウメッセージ</param>
        protected override void WndProc(ref Message m)
        {
            switch (m.Msg)
            {
                // マウスアクティベート
                case (int)Foundation.Win32.WM.WM_MOUSEACTIVATE:
                    m.Result = (IntPtr)Foundation.Win32.WM.WM_ACTIVATE;
                    return;
            }

            base.WndProc(ref m);
        }
    }
}
