﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.BusinessLogic.Options;
using EffectMaker.BusinessLogic.RuntimeOptions;
using EffectMaker.Foundation.Log;

namespace EffectMaker.Application.CommandLine
{
    /// <summary>
    /// シェーダコンバートオプションを処理します。
    /// </summary>
    public class ShaderOptionProcessor : CommandLineProcessorBase
    {
        /// <summary>
        /// シェーダオプションです。
        /// </summary>
        private string shaderOption;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="workingData">作業データ</param>
        /// <param name="shaderOption">シェーダオプション</param>
        public ShaderOptionProcessor(CommandLineWorkingData workingData, string shaderOption)
            : base(workingData)
        {
            this.shaderOption = shaderOption;
        }

        /// <summary>
        /// エラーログを取得します。
        /// </summary>
        public override string ErrorReport { get { return string.Empty; } }

        /// <summary>
        /// 設定処理を行います。
        /// </summary>
        /// <param name="args">パラメーター</param>
        /// <returns>処理が正常に完了したときtrue, それ以外はfalseを返します。</returns>
        public override bool Setup()
        {
            switch (this.shaderOption)
            {
                case "fast":
                    OptionStore.RuntimeOptions.ShaderConvertOption = ShaderConvertOption.Fast;
                    break;
                case "small":
                    OptionStore.RuntimeOptions.ShaderConvertOption = ShaderConvertOption.Small;
                    break;
                case "cache":
                    OptionStore.RuntimeOptions.ShaderConvertOption = ShaderConvertOption.Cache;
                    break;
                case "buildcache":
                    OptionStore.RuntimeOptions.ShaderConvertOption = ShaderConvertOption.BuildCache;
                    break;
                default:
                    Logger.Log("Console", LogLevels.Error, Properties.Resources.ConsoleMsgInvalidShaderOption, this.shaderOption);
                    return false;
            }

            return true;
        }

        /// <summary>
        /// コマンドライン処理を行います。
        /// </summary>
        /// <returns>処理が正常に完了したときtrue, それ以外はfalseを返します。</returns>
        public override bool Process()
        {
            return true;
        }

        /// <summary>
        /// 書き換えた設定などを復元します。
        /// </summary>
        public override void Cleanup()
        {
        }
    }
}
