﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.Application.AutoBackup;
using EffectMaker.Application.CommandLine;
using EffectMaker.Foundation.Log;
using EffectMaker.UIControls.DebugConsole;

namespace EffectMaker.Application
{
    /// <summary>
    /// アプリケーションデータです。
    /// </summary>
    public static class AppData
    {
        /// <summary>
        /// DebugConsoleを取得または設定します。
        /// </summary>
        public static DebugConsole DebugConsole { get; set; }

        /// <summary>
        /// ConsoleDisplayを取得または設定します。
        /// </summary>
        public static ConsoleDisplay ConsoleDisplay { get; set; }

        /// <summary>
        /// BridgeCommandProcessorを取得または設定します。
        /// </summary>
        public static BridgeCommandProcessor BridgeCommandProcessor { get; set; }

        /// <summary>
        /// AutoBackupManagerを取得または設定します。
        /// </summary>
        public static AutoBackupManager AutoBackupManager { get; set; }
    }
}
