﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.Application.Properties;
using EffectMaker.BusinessLogic.BinaryHeaders;
using EffectMaker.DataModel.Specific.Serializer;
using EffectMaker.UIDialogs.GeneralControls;
using Microsoft.VisualBasic.ApplicationServices;

namespace EffectMaker.Application.AboutDialog
{
    /// <summary>
    /// バージョン情報ダイアログ.
    /// </summary>
    public partial class AboutDialog : ModalDialog
    {
        /// <summary>
        /// コンストラクタ.
        /// </summary>
        public AboutDialog()
        {
            this.InitializeComponent();

            // アイコンの表示.
            this.IconPicture.Image = new Icon(Properties.Resources.Icon_EffectMaker, 48, 48).ToBitmap();

            Assembly assembly = Assembly.GetExecutingAssembly();
            FileVersionInfo info = FileVersionInfo.GetVersionInfo(assembly.Location);

            string strBuiltTime = string.Format(
                Properties.Resources.AboutDialogBuildDate + "：{0} {1}",
                VersionInformation.BuildDate.ToShortDateString(),
                VersionInformation.BuildDate.ToShortTimeString());

            string strEsetVersion = string.Format(
                "{0}：{1}",
                Resources.AboutDialogEditorDataModelVersion,
                DataModelSerializer.Instance.Version.ToString());

            string strBinaryVersion = string.Format(
                "{0}：0x{1}",
                Properties.Resources.AboutDialogBinaryVersion,
                BinaryFileHeader.Version.ToString("X8"));

            // テキストを設定.
            this.ProductLabel.Text = string.Format(
                                            "{0} Ver. {1}.{2}.{3} (Release {4})",
                                            info.ProductName,
                                            info.ProductMajorPart,
                                            info.ProductMinorPart,
                                            info.ProductBuildPart,
                                            info.ProductPrivatePart);

            this.BuildInfoLabel.Text = string.Format(
                "{0}\n{1}\n{2}", strEsetVersion, strBinaryVersion, strBuiltTime);

            // コピーライト情報を取得
            this.CopyrightLabel.Text = CopyrightString;
        }

        /// <summary>
        /// コピーライト情報を取得
        /// </summary>
        public static string CopyrightString
        {
            get
            {
                Assembly mainAssembly = Assembly.GetEntryAssembly();

                object[] copyrightArray =
                  mainAssembly.GetCustomAttributes(typeof(AssemblyCopyrightAttribute), false);
                if (copyrightArray.Length > 0)
                {
                    return ((AssemblyCopyrightAttribute)copyrightArray[0]).Copyright;
                }

                return string.Empty;
            }
        }

        /// <summary>
        /// バージョン情報.
        /// </summary>
        public static class VersionInformation
        {
            /// <summary>
            /// ビルド日時.
            /// </summary>
            public static DateTime BuildDate
            {
                get
                {
                    Assembly entry = Assembly.GetEntryAssembly();
                    Version version = entry.GetName().Version;
                    DateTime buildDate = new DateTime(2000, 1, 1, 0, 0, 0);
                    buildDate = buildDate.AddDays((double)version.Build);
                    buildDate = buildDate.AddSeconds((double)version.Revision * 2.0);
                    return buildDate;
                }
            }
        }
    }
}
