﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare
  File:     CustomShader_AreaLoop.vsh

  Copyright (C)2011-2013 Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#define ubo_RepeatOffsetX   sysEmitterPluginUniformBlockParam0.x  //!< リピート毎のオフセットX
#define ubo_RepeatOffsetY   sysEmitterPluginUniformBlockParam0.y  //!< リピート毎のオフセットY
#define ubo_RepeatOffsetZ   sysEmitterPluginUniformBlockParam0.z  //!< リピート毎のオフセットZ
#define ubo_IsCameraLoop    sysEmitterPluginUniformBlockParam0.w  //!< カメラ前ループかどうか
#define ubo_AlphaRatioX     sysEmitterPluginUniformBlockParam1.x  //!< 端でαを薄くする割合X
#define ubo_AlphaRatioY     sysEmitterPluginUniformBlockParam1.y  //!< 端でαを薄くする割合Y
#define ubo_AlphaRatioZ     sysEmitterPluginUniformBlockParam1.z  //!< 端でαを薄くする割合Z
// #define dummy            sysEmitterPluginUniformBlockParam1.w  //!< [ダミー]

//!< 座標系変換行列
#define ubo_BoxMat0         sysEmitterPluginUniformBlockParam2
#define ubo_BoxMat1         sysEmitterPluginUniformBlockParam3
#define ubo_BoxMat2         sysEmitterPluginUniformBlockParam4
#define ubo_BoxMat3         sysEmitterPluginUniformBlockParam5

//!< 座標系変換逆行列
#define ubo_BoxMatInv0      sysEmitterPluginUniformBlockParam6
#define ubo_BoxMatInv1      sysEmitterPluginUniformBlockParam7
#define ubo_BoxMatInv2      sysEmitterPluginUniformBlockParam8
#define ubo_BoxMatInv3      sysEmitterPluginUniformBlockParam9

#define ubo_ClippingType    sysEmitterPluginUniformBlockParam10.x   //!< クリッピングタイプ
#define ubo_ClipWorldHeight sysEmitterPluginUniformBlockParam10.y   //!< クリッピング平面の高さ

#define ubo_BoxScaleX    sysEmitterPluginUniformBlockParam11.x   //!< 箱のスケールの逆数X
#define ubo_BoxScaleY    sysEmitterPluginUniformBlockParam11.y   //!< 箱のスケールの逆数Y
#define ubo_BoxScaleZ    sysEmitterPluginUniformBlockParam11.z   //!< 箱のスケールの逆数Z

//---------------------------------------------------
// ユーティリティ関数の前方宣言
// 一般ユーザーに公開しても良ければeft_ParticleDeclaration.vshへ
//---------------------------------------------------
mat4 MakeRotationMatrixXYZ( vec3 rotate );
mat4 MakeRotationMatrixZXY( vec3 rotate );

//--------------------------------------------------------------
// エミッタプラグイン処理
//--------------------------------------------------------------
#define USE_EMITTER_PLUGIN_FINAL_ADJUSTMENT_VERTEX_PROCSS
void EP_FinalAdjustmentVertexProcess(){}

//--------------------------------------------------------------
// エミッタプラグイン：指定範囲内ループ
//--------------------------------------------------------------
#define USE_EMITTER_PLUGIN_ADJUSTMENT_WORLD_POSITION
void EP_AdjustmentWorldPosition()
{
    //--------------------------------------------------
    // 指定サイズの箱の内部にPTCLを収める処理
    //
    // ※PTCL中心点を使用しているのは、４点すべてを同じ基準点で動かすため。
    // 頂点位置（gl_Position.xyz）に上記処理で得た移動量を加算する。
    //--------------------------------------------------

    // UBOの値をそれぞれベクトルに組み直す
    vec3 BOX_ALPHA_RATIO =  vec3( ubo_AlphaRatioX, ubo_AlphaRatioY, ubo_AlphaRatioZ );
    vec3 REPEAT_OFFSET =    vec3( ubo_RepeatOffsetX, ubo_RepeatOffsetY, ubo_RepeatOffsetZ );

    // 計算用変数
    float alphaRatio = 1;                               // 最後にアルファ値に乗算する値
    vec4 worldPos = vec4( sysPtclWorldPos.xyz, 1 );     // 関数呼び出し時点でのPTCLのワールド座標
    vec4 loopPos = worldPos;                            // 処理用のPTCL位置（※初期値はワールド座標）
    loopPos.xyz += REPEAT_OFFSET;

    //--------------------------------------------------
    // 座標系変換行列の準備
    //--------------------------------------------------
    mat4 transMat, invTransMat; // 変換行列＆逆行列
    {
        transMat[0] = ubo_BoxMat0;
        transMat[1] = ubo_BoxMat1;
        transMat[2] = ubo_BoxMat2;
        transMat[3] = ubo_BoxMat3;

        invTransMat[0] = ubo_BoxMatInv0;
        invTransMat[1] = ubo_BoxMatInv1;
        invTransMat[2] = ubo_BoxMatInv2;
        invTransMat[3] = ubo_BoxMatInv3;
    }

    //--------------------------------------------------
    // 範囲内ループ処理
    //--------------------------------------------------
    vec4 alphaPos = vec4( 1, 1, 1, 1 );     // 箱の端のα値の計算用（0.0～1.0）
    {
        // Box座標系に変換
        loopPos = invTransMat * loopPos;    // float[M] * float[M][M] の順（※GLSLは列優先で行列を持つため。）
        loopPos.w = 1;

        loopPos.x /= ubo_BoxScaleX;
        loopPos.y /= ubo_BoxScaleY;
        loopPos.z /= ubo_BoxScaleZ;

        // [-1, 1]→[0, 1] 変換
        loopPos.xyz *= 0.5;
        loopPos.xyz += vec3( 0.5, 0.5, 0.5 );

        // 小数部分を取り出す
        loopPos.xyz = fract( loopPos.xyz );
        alphaPos = loopPos;                  // この値はαの計算に使うので保存

        // 元の座標系に戻す
        loopPos.xyz -= vec3( 0.5, 0.5, 0.5 );
        loopPos.xyz *= 2.0;

        loopPos.x *= ubo_BoxScaleX;
        loopPos.y *= ubo_BoxScaleY;
        loopPos.z *= ubo_BoxScaleZ;

        loopPos = transMat * loopPos;

        // 移動差分を取り出し、頂点位置に加算
        vec3 diff = loopPos.xyz - worldPos.xyz;

        // 更新が必要な変数に差分を適用して動かす。
        gl_Position.xyz += diff.xyz;
        sysPtclWorldPos += diff.xyz;

        // ワールドY座標が指定値の上下でクリップする処理
        float clipY = ubo_ClipWorldHeight;
        if( ubo_ClippingType == 1 )
        {
            if( sysPtclWorldPos.y > clipY )
            {
                DiscardVertex();
                return;
            }
        }
        else if( ubo_ClippingType == 2 )
        {
            if( sysPtclWorldPos.y < clipY )
            {
                DiscardVertex();
                return;
            }
        }
    }

    //--------------------------------------------------
    // 箱の端のαを薄くする処理
    //--------------------------------------------------
    {
#if 1
        // 箱の端αは0にして、箱内のある割合の位置からグラデーション開始。
        vec3 gradPos = alphaPos.xyz * 2 - vec3( 1, 1, 1 ); // [-1.0, +1.0)
        vec3 mul = vec3( 1, 1, 1 ) - abs( gradPos );

        if( BOX_ALPHA_RATIO.x > 0 ){ mul.x = clamp( mul.x / BOX_ALPHA_RATIO.x, 0, 1 ); }
        else { mul.x = 1; }
        if( BOX_ALPHA_RATIO.y > 0 ){ mul.y = clamp( mul.y / BOX_ALPHA_RATIO.y, 0, 1 ); }
        else { mul.y = 1; }
        if( BOX_ALPHA_RATIO.z > 0 ){ mul.z = clamp( mul.z / BOX_ALPHA_RATIO.z, 0, 1 ); }
        else { mul.z = 1; }
        alphaRatio *= mul.x * mul.y * mul.z;
#endif

#if 0
        // ★Variation: 2014初頭にカスタムシェーダに移植したときの元コード
        vec3 mulA0 = clamp( gradPos.xyz / BOX_ALPHA_RATIO, 0, 1 );                            // 0.0f  ～ 指定値 のα減衰値
        vec3 mulA1 = clamp((( vec3( 1, 1, 1 ) - gradPos.xyz ) / BOX_ALPHA_RATIO ), 0, 1 );    // 指定値～ 1.0f   のα減衰値
        vec3 mulA = mulA0 * mulA1;
        // 減衰値をαに反映
        alphaRatio *= mulA.x * mulA.y * mulA.z;
#endif

#if 0
        // ★Variation: 箱の端をα（X/Y/Z）とするやり方
        alphaRatio *= smoothstep( 1.01, ubo_AlphaRatioX, abs( alphaPos.x ));
        alphaRatio *= smoothstep( 1.01, ubo_AlphaRatioY, abs( alphaPos.y ));
        alphaRatio *= smoothstep( 1.01, ubo_AlphaRatioZ, abs( alphaPos.z ));
#endif
    }

    // 最終αに反映
    sysMasterAlpha *= alphaRatio;
}
