﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class ModelTransformBinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>A flag to prevent the static constructor being called more than once.</summary>
        private static bool isStaticConstructorCalled = false;

        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static ModelTransformBinaryConversionInfo()
        {
            if (isStaticConstructorCalled == true)
            {
                return;
            }

            isStaticConstructorCalled = true;

            instanceMap = new Dictionary<DataModelBase, BinaryConversionInfoBase>();

            var modelTransformUserBinary = new BinaryStructDefinition(typeof(ModelTransformUserData)) { HasBinaryHeader = false };

            // Output : matrixSetType
            // Inputs : MatrixSetType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelTransformUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("MatrixSetType", new Guid("fade499a-13d7-42c5-87cf-5d70ab08e1f8"))
            );

            // Output : matrixApplyType
            // Inputs : MatrixApplyType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelTransformUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("MatrixApplyType", new Guid("9f7b1132-2c5c-4575-b733-d293c4e93873"))
            );

            // Output : modelGuid
            // Inputs : ModelGuid
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelTransformUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ModelGuid", new Guid("336f076b-b133-4f71-89b0-c548abc5278a"))
            );

            // Output : boneIndex
            // Inputs : BoneIndex
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelTransformUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("BoneIndex", new Guid("9ef7dc2c-aea8-4b8b-a4a3-5ec11c4b0eab"))
            );

            // Output : offsetPosition
            // Inputs : OffsetPosition
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelTransformUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("OffsetPosition", new Guid("b414fb74-612e-4007-86bd-c75fdb2c825c"))
            );

            // Output : offsetScale
            // Inputs : OffsetScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelTransformUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("OffsetScale", new Guid("e0875af1-a6d0-4c99-8e4c-32b1ecc3a70b"))
            );

            // Output : offsetRotateX
            // Inputs : OffsetRotation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelTransformUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SelectPrimitiveChannelConverter),
                    new ConverterParam("ChannelIndex", 0),
                    new ConverterParam("RadianConvertMode", 1)),
                null,
                new InputPropertyDefinition("OffsetRotation", new Guid("025d0153-21e4-4601-8692-dc79730120db"))
            );

            // Output : offsetRotateY
            // Inputs : OffsetRotation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelTransformUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SelectPrimitiveChannelConverter),
                    new ConverterParam("ChannelIndex", 1),
                    new ConverterParam("RadianConvertMode", 1)),
                null,
                new InputPropertyDefinition("OffsetRotation", new Guid("025d0153-21e4-4601-8692-dc79730120db"))
            );

            // Output : offsetRotateZ
            // Inputs : OffsetRotation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelTransformUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SelectPrimitiveChannelConverter),
                    new ConverterParam("ChannelIndex", 2),
                    new ConverterParam("RadianConvertMode", 1)),
                null,
                new InputPropertyDefinition("OffsetRotation", new Guid("025d0153-21e4-4601-8692-dc79730120db"))
            );

            // Output : isEmitterBillboard
            // Inputs : IsEmitterBillboard
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                modelTransformUserBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (int)1) }),
                    new ConverterParam("DefaultOutput", (int)0)),
                null,
                new InputPropertyDefinition("IsEmitterBillboard", new Guid("616d566d-a462-497d-80c0-49c9ef5cc4e6"))
            );


            //-----------------------------------------------------------------
            // Save the binary structure definition.
            //-----------------------------------------------------------------
            rootBinaryDefinition = modelTransformUserBinary;
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private ModelTransformBinaryConversionInfo(DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }
    }
}
