﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class EPAreaLoopBinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>A flag to prevent the static constructor being called more than once.</summary>
        private static bool isStaticConstructorCalled = false;

        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static EPAreaLoopBinaryConversionInfo()
        {
            if (isStaticConstructorCalled == true)
            {
                return;
            }

            isStaticConstructorCalled = true;

            instanceMap = new Dictionary<DataModelBase, BinaryConversionInfoBase>();

            var ePAreaLoopBinary = new BinaryStructDefinition(typeof(EPAreaLoopData)) { HasBinaryHeader = false };

            // Output : repeatOffsetPos
            // Inputs : RepeatOffsetPos
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePAreaLoopBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RepeatOffsetPos", new Guid("0c2298ee-b985-4a72-b727-4256e0d2a716"))
            );

            // Output : repeatNum
            // Inputs : RepeatNum
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePAreaLoopBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("RepeatNum", new Guid("3bc9bf0e-2b0e-42a8-b095-82805b00003a"))
            );

            // Output : areaSize
            // Inputs : AreaSize
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePAreaLoopBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("AreaSize", new Guid("c2e42fad-3d6c-4fcd-9062-705eece96da8"))
            );

            // Output : clippingWorldHeight
            // Inputs : ClippingWorldHeight
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePAreaLoopBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ClippingWorldHeight", new Guid("bcd38ccb-8bc3-45ea-a976-25f4a7a4034d"))
            );

            // Output : areaPos
            // Inputs : AreaPos
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePAreaLoopBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("AreaPos", new Guid("cb199e6c-11ae-41b1-aa14-eebb679c3416"))
            );

            // Output : clippingType
            // Inputs : ClippingType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePAreaLoopBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ClippingType", new Guid("1d640c35-2e48-492d-b1d8-2022d89369d4"))
            );

            // Output : alphaRatio
            // Inputs : AlphaRatio
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePAreaLoopBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("AlphaRatio", new Guid("874653a2-ad6b-4ed9-b883-ffd8bca08146"))
            );

            // Output : isCameraLoop
            // Inputs : IsCameraLoop
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePAreaLoopBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, 1.0f), new SwitchCase(false, 0.0f) }),
                    new ConverterParam("DefaultOutput", 0.0f)),
                null,
                new InputPropertyDefinition("IsCameraLoop", new Guid("15285afb-b4ce-4a9e-b5f0-f209caf4b3ee"))
            );

            // Output : areaRotate
            // Inputs : AreaRotate
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePAreaLoopBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(RadianConverter)),
                null,
                new InputPropertyDefinition("AreaRotate", new Guid("32bc5ab1-91fc-47c6-8048-1ed4d523cbd2"))
            );

            // Output : reserved0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                4,
                ePAreaLoopBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );


            //-----------------------------------------------------------------
            // Save the binary structure definition.
            //-----------------------------------------------------------------
            rootBinaryDefinition = ePAreaLoopBinary;
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private EPAreaLoopBinaryConversionInfo(DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }
    }
}
