﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// The user data data model class.
    /// </summary>
    [Serializable]
    public class CustomActionSetting3 : CustomActionSettingData
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public CustomActionSetting3() :
            base()
        {
            this.Flag0 = 0x00000000;
            this.IntParam0 = 0;
            this.IntParam1 = 0;
            this.IntParam2 = 0;
            this.IntParam3 = 0;
            this.IntParam4 = 0;
            this.IntParam5 = 0;
            this.FloatParam0 = 0f;
            this.FloatParam1 = 0f;
            this.FloatParam2 = 0f;
            this.FloatParam3 = 0f;
            this.FloatParam4 = 0f;
            this.FloatParam5 = 0f;
            this.FloatParam6 = 0f;
            this.FloatParam7 = 0f;

            this.PostConstruct();
        }

        /// <summary>
        /// Get or set the flag value 0.
        /// </summary>
        [DataModelPropertyGuid("a7faa09e-b465-4163-a840-9a48471232b9")]
        public uint Flag0 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 0.
        /// </summary>
        [DataModelPropertyGuid("80b235d6-5fb2-4c7b-bf25-756ac475ab1d")]
        public int IntParam0 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 1.
        /// </summary>
        [DataModelPropertyGuid("e5ccad98-c05a-4092-807c-787b7153c618")]
        public int IntParam1 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 2.
        /// </summary>
        [DataModelPropertyGuid("5be466c0-e4b7-4a26-8b14-4205bb1a46fd")]
        public int IntParam2 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 3.
        /// </summary>
        [DataModelPropertyGuid("7619fbd9-550c-4b83-96fb-c7d1e6b5679a")]
        public int IntParam3 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 4.
        /// </summary>
        [DataModelPropertyGuid("ca3475cc-3e35-4517-ab4d-ca565ee94d26")]
        public int IntParam4 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 5.
        /// </summary>
        [DataModelPropertyGuid("248070ad-b42a-437d-be9f-1f788d358a8a")]
        public int IntParam5 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 0.
        /// </summary>
        [DataModelPropertyGuid("f9aefca1-81d6-4ec4-b81a-9368fb7f3457")]
        public float FloatParam0 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 1.
        /// </summary>
        [DataModelPropertyGuid("5ee8946a-3e48-49dd-9fec-553fe761cdc2")]
        public float FloatParam1 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 2.
        /// </summary>
        [DataModelPropertyGuid("f38768da-dca7-4d60-bdd1-de06ddea5ff1")]
        public float FloatParam2 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 3.
        /// </summary>
        [DataModelPropertyGuid("73569c34-4713-477f-a888-1e4cc2c579da")]
        public float FloatParam3 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 4.
        /// </summary>
        [DataModelPropertyGuid("b5fefdf3-188f-4e95-82c3-5a5b3a2b397b")]
        public float FloatParam4 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 5.
        /// </summary>
        [DataModelPropertyGuid("9b53bb4b-4369-4bb7-82d8-5ba4b194be99")]
        public float FloatParam5 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 6.
        /// </summary>
        [DataModelPropertyGuid("bccf6b86-16ba-4d7a-ab9d-91ba9c3024b6")]
        public float FloatParam6 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 7.
        /// </summary>
        [DataModelPropertyGuid("402e0bc6-58c7-41bf-a0e7-3ad8cb4a9aa2")]
        public float FloatParam7 { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.CustomActionSetting3;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Flag0 = srcDataModel.Flag0;
            this.IntParam0 = srcDataModel.IntParam0;
            this.IntParam1 = srcDataModel.IntParam1;
            this.IntParam2 = srcDataModel.IntParam2;
            this.IntParam3 = srcDataModel.IntParam3;
            this.IntParam4 = srcDataModel.IntParam4;
            this.IntParam5 = srcDataModel.IntParam5;
            this.FloatParam0 = srcDataModel.FloatParam0;
            this.FloatParam1 = srcDataModel.FloatParam1;
            this.FloatParam2 = srcDataModel.FloatParam2;
            this.FloatParam3 = srcDataModel.FloatParam3;
            this.FloatParam4 = srcDataModel.FloatParam4;
            this.FloatParam5 = srcDataModel.FloatParam5;
            this.FloatParam6 = srcDataModel.FloatParam6;
            this.FloatParam7 = srcDataModel.FloatParam7;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Flag0", this.Flag0);
            this.WriteElement(context, "IntParam0", this.IntParam0);
            this.WriteElement(context, "IntParam1", this.IntParam1);
            this.WriteElement(context, "IntParam2", this.IntParam2);
            this.WriteElement(context, "IntParam3", this.IntParam3);
            this.WriteElement(context, "IntParam4", this.IntParam4);
            this.WriteElement(context, "IntParam5", this.IntParam5);
            this.WriteElement(context, "FloatParam0", this.FloatParam0);
            this.WriteElement(context, "FloatParam1", this.FloatParam1);
            this.WriteElement(context, "FloatParam2", this.FloatParam2);
            this.WriteElement(context, "FloatParam3", this.FloatParam3);
            this.WriteElement(context, "FloatParam4", this.FloatParam4);
            this.WriteElement(context, "FloatParam5", this.FloatParam5);
            this.WriteElement(context, "FloatParam6", this.FloatParam6);
            this.WriteElement(context, "FloatParam7", this.FloatParam7);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Flag0 = this.ReadElement(context, "Flag0", this.Flag0);
            this.IntParam0 = this.ReadElement(context, "IntParam0", this.IntParam0);
            this.IntParam1 = this.ReadElement(context, "IntParam1", this.IntParam1);
            this.IntParam2 = this.ReadElement(context, "IntParam2", this.IntParam2);
            this.IntParam3 = this.ReadElement(context, "IntParam3", this.IntParam3);
            this.IntParam4 = this.ReadElement(context, "IntParam4", this.IntParam4);
            this.IntParam5 = this.ReadElement(context, "IntParam5", this.IntParam5);
            this.FloatParam0 = this.ReadElement(context, "FloatParam0", this.FloatParam0);
            this.FloatParam1 = this.ReadElement(context, "FloatParam1", this.FloatParam1);
            this.FloatParam2 = this.ReadElement(context, "FloatParam2", this.FloatParam2);
            this.FloatParam3 = this.ReadElement(context, "FloatParam3", this.FloatParam3);
            this.FloatParam4 = this.ReadElement(context, "FloatParam4", this.FloatParam4);
            this.FloatParam5 = this.ReadElement(context, "FloatParam5", this.FloatParam5);
            this.FloatParam6 = this.ReadElement(context, "FloatParam6", this.FloatParam6);
            this.FloatParam7 = this.ReadElement(context, "FloatParam7", this.FloatParam7);

            return success;
        }
    }
}
