﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.ObjectModel;
using System.Windows;
using System.Windows.Controls;
using CombinerNodeEditor.ViewModel;

namespace CombinerNodeEditor.UserControl
{
    /// <summary>
    /// NodeTreeView.xaml の相互作用ロジック
    /// </summary>
    public partial class NodeTreeView : System.Windows.Controls.UserControl
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public NodeTreeView()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// データコンテキストの変更イベントです。
        /// </summary>
        /// <param name="sender">イベントの発生元</param>
        /// <param name="e">イベント情報</param>
        private void NodeTreeView_DataContextChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            if (e.NewValue != null)
            {
                if (this.DataContext is DataModel)
                {
                    // Rootフォルダー表示用に、TreeItemにDataModelの設定
                    this.NodeTree.ItemsSource = new ObservableCollection<DataModel>() { (DataModel)this.DataContext };
                    return;
                }
            }

            this.NodeTree.ItemsSource = null;
        }

        /// <summary>
        /// ツリービューの選択イベントです。
        /// </summary>
        /// <param name="sender">イベントの発生元</param>
        /// <param name="e">イベント情報</param>
        private void TreeViewItem_Selected(object sender, RoutedEventArgs e)
        {
            TreeViewItem item = e.Source as TreeViewItem;
            if (item != null)
            {
                // 選択したノードまでスクロール
                item.BringIntoView();
                e.Handled = true;
                if (this.DataContext is DataModel)
                {
                    var dataModel = this.DataContext as DataModel;
                    if (item.DataContext is ITreeViewItem)
                    {
                        dataModel.SelectedItem = (ITreeViewItem)item.DataContext;
                    }
                }
            }
        }

        /// <summary>
        /// ツリービューの選択解除イベントです。
        /// </summary>
        /// <param name="sender">イベントの発生元</param>
        /// <param name="e">イベント情報</param>
        private void TreeViewItem_Unselected(object sender, RoutedEventArgs e)
        {
            TreeViewItem item = e.Source as TreeViewItem;
            if (item != null)
            {
                // 選択したノードまでスクロール
                item.BringIntoView();
                e.Handled = true;

                if (this.DataContext is DataModel)
                {
                    ((DataModel)this.DataContext).SelectedItem = null;
                }
            }
        }
    }
}
