﻿/// <tag name="Utility">
///  <func id="Blinn_CalcNormalMap"/>
/// </tag>
/// <func id="Blinn_CalcNormalMap" name="Blinn_CalcNormalMap">
///  <in name="normalMapTx" type="vec4"/>
///  <return type="vec3"/>
///  <description>法線マップ計算</description>
/// </func>
/// <block guid="{3F6C93B3-BCB9-510b-95C8-5DCA7F4A38A9}" displayname="Blinn_CalcNormalMap">
///  <func id="Blinn_CalcNormalMap"/>
///  <in displayname="normalMapTx" type="vec4" target="normalMapTx"/>
///  <out displayname="xyz" type="vec3" target="return"/>
/// </block>
/// <code>
vec3 Blinn_CalcNormalMap(vec4 normalMapTx)
{
    vec3  normal = sysWorldNormalVary;

    normalMapTx.z = sqrt( clamp(
                    1.0 -( normalMapTx.x*normalMapTx.x + normalMapTx.y*normalMapTx.y ), 0.0, 1.0 ) );
    normal = normalMapTx.x * sysWorldTangentVary  +
             normalMapTx.y * sysWorldBinormalVary +
             normalMapTx.z * sysWorldNormalVary;
    normal = normalize( normal );

    // 法線マップによるライティング
    vec3 lightWorldPos = vec3( 0.0, 100, 100 );
    vec3 position      = vec3( sysViewMatrix * vec4( sysWorldPositionVary, 1.0 ) );
    vec3 lightPos      = vec3( sysViewMatrix * vec4( lightWorldPos, 1 ) );
    vec3 lightVec      = normalize( lightPos - position );
    vec3 viewNormal    = normalize( ( sysViewMatrix * vec4( normal, 1 ) ).xyz );

    float diffuse = dot( lightVec, viewNormal );

    normal.y = diffuse;

    return normal;
}
/// </code>
