﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace CombinerNodeEditor.Dialog
{
    /// <summary>
    /// AddNewFileDialog.xaml の相互作用ロジック
    /// </summary>
    public partial class AddNewFileDialog : Window
    {
        public class AddNewFileDialogResult
        {
            public string NewFilePath { get; set; }

            public AddNewFileDialogResult()
            {
                NewFilePath = "new_node_definition.glsl";
            }
        };

        private AddNewFileDialogResult result = new AddNewFileDialogResult();

        public string NewFilePath
        {
            get { return result.NewFilePath; }
        }

        public AddNewFileDialog()
        {
            result = new AddNewFileDialogResult();
            this.DataContext = result;

            InitializeComponent();
        }

        private void Button_OK_Click(object sender, RoutedEventArgs e)
        {
            this.DialogResult = true;
            this.Close();
        }

        private void Button_Cancel_Click(object sender, RoutedEventArgs e)
        {
            this.DialogResult = false;
            this.Close();
        }

        private void Window_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Enter)
            {
                this.DialogResult = true;
                this.Close();
            }
            else if (e.Key == Key.Escape)
            {
                this.DialogResult = false;
                this.Close();
            }
        }

        private void TextBox_NewFilePath_Initialized(object sender, EventArgs e)
        {
            // ファイル名部分を選択状態にしておく
            this.TextBox_NewFilePath.Focus();
            this.TextBox_NewFilePath.Select(0, this.TextBox_NewFilePath.Text.LastIndexOf('.'));
        }
    }
}
