﻿/// <tag name="Texture">
///  <func id="GetTextureCrd0"/>
/// </tag>
/// <func id="GetTextureCrd0" name="GetTextureCrd0">
///  <return type="vec2"/>
///  <description>テクスチャ0のUV座標</description>
/// </func>
/// <block guid="{7FD25831-B08B-499c-80ED-F9C1FC1ACF20}" displayname="TexCrd0">
///  <func id="GetTextureCrd0"/>
///  <out displayname="uv" type="vec2" target="return" semantic="TexCoord0"/>
/// </block>
vec2 GetTextureCrd0()
{
  return sysTexCoord01Vary.xy;
}


/// <tag name="Texture">
///  <func id="GetTextureCrd1"/>
/// </tag>
/// <func id="GetTextureCrd1" name="GetTextureCrd1">
///  <return type="vec2"/>
///  <description>テクスチャ1のUV座標</description>
/// </func>
/// <block guid="{3F574DCC-3B6F-4051-B418-FB30BF251734}" displayname="TexCrd1">
///  <func id="GetTextureCrd1"/>
///  <out displayname="uv" type="vec2" target="return" semantic="TexCoord1"/>
/// </block>
vec2 GetTextureCrd1()
{
  return sysTexCoord01Vary.zw;
}


/// <tag name="Texture">
///  <func id="GetTextureCrd2"/>
/// </tag>
/// <func id="GetTextureCrd2" name="GetTextureCrd2">
///  <return type="vec2"/>
///  <description>テクスチャ2のUV座標</description>
/// </func>
/// <block guid="{3F574DCC-3B6F-4051-B418-FB30BF251739}" displayname="TexCrd2">
///  <func id="GetTextureCrd2"/>
///  <out displayname="uv" type="vec2" target="return" semantic="TexCoord2"/>
/// </block>
vec2 GetTextureCrd2()
{
  return sysTexCoord2Vary;
}


/// <tag name="Texture">
///  <func id="GetProjectionTextureCrd"/>
/// </tag>
/// <func id="GetProjectionTextureCrd" name="GetProjectionTextureCrd">
///  <return type="vec4"/>
///  <description>投影テクスチャのUV座標</description>
/// </func>
/// <block guid="{202BEFC8-75AF-4add-A0C0-A2CFB299B95A}" displayname="ProjTexCrd">
///  <func id="GetProjectionTextureCrd"/>
///  <out displayname="ProjPos4" type="vec4" target="return"/>
/// </block>
vec4 GetProjectionTextureCrd()
{
  return sysFragCoordVary;
}


/// <tag name="Texture">
///  <func id="GetProjectionTextureSRTCrd0"/>
/// </tag>
/// <func id="GetProjectionTextureSRTCrd0" name="GetProjectionTextureSRTCrd0">
///  <return type="vec4"/>
///  <description>投影テクスチャ0のUV座標</description>
/// </func>
/// <block guid="{202BEFC8-75AF-4add-A0C0-A2CFB299B96A}" displayname="ProjTexCrdSRT0">
///  <func id="GetProjectionTextureSRTCrd0"/>
///  <out displayname="ProjPos4" type="vec4" target="return"/>
/// </block>
vec4 GetProjectionTextureSRTCrd0()
{
//  return v_outProjectionTexSRT0CoordProj;
  return sysFragCoordVary;
}


/// <tag name="Texture">
///  <func id="GetProjectionTextureSRTCrd1"/>
/// </tag>
/// <func id="GetProjectionTextureSRTCrd1" name="GetProjectionTextureSRTCrd1">
///  <return type="vec4"/>
///  <description>投影テクスチャ1のUV座標</description>
/// </func>
/// <block guid="{202BEFC8-75AF-4add-A0C0-A2CFB299B97A}" displayname="ProjTexCrdSRT1">
///  <func id="GetProjectionTextureSRTCrd1"/>
///  <out displayname="ProjPos4" type="vec4" target="return"/>
/// </block>
vec4 GetProjectionTextureSRTCrd1()
{
//  return v_outProjectionTexSRT1CoordProj;
  return sysFragCoordVary;
}


/// <tag name="Texture">
///  <func id="SphereMapUV"/>
/// </tag>
/// <func id="SphereMapUV" name="SphereMapUV">
///  <return type="vec2"/>
///  <description>スフィアマップUV座標</description>
/// </func>
/// <block guid="{48943685-4DFC-4e96-85E5-150A93754A9F}" displayname="SphereMapUV">
///  <func id="SphereMapUV"/>
///  <out displayname="uv" type="vec2" target="return"/>
///  <out displayname="u" type="float" target="return.x"/>
///  <out displayname="v" type="float" target="return.y"/>
/// </block>
vec2 SphereMapUV()
{
  vec3 viewPosition = normalize( ( vec4( sysWorldPositionVary, 1 ) * viewMat ).xyz );
  vec3 viewNormal   = normalize( ( vec4( sysWorldNormalVary,   0 ) * viewMat ).xyz );

  vec3 r = reflect( viewPosition, viewNormal );
  float rZ = r.z+1.0;
  float m = 2.0 * sqrt( r.x*r.x + r.y*r.y + rZ*rZ );

  vec2 vSphereTexCoord;
  vSphereTexCoord.s = r.x/m + 0.5;
  vSphereTexCoord.t = -r.y/m + 0.5;

  return vSphereTexCoord;
}


/// <tag name="Texture">
///   <func id="GetScreenUV" />
/// </tag>
/// <func id="GetScreenUV" name="GetScreenUV">
///   <return type="vec2" />
///   <description>ピクセルのスクリーン座標系での相対位置 [0.0, 1.0]</description>
/// </func>
/// <block guid="{9AD0F180-DA11-4B36-AB9E-B376BA90D532}" displayname="ScreenUV">
///   <func id="GetScreenUV"/>
///   <out displayname="uv" type="vec2" target="return" />
///   <out displayname="u" type="float" target="return.x" />
///   <out displayname="v" type="float" target="return.y" />
/// </block>
vec2 GetScreenUV()
{
  float invW = 1.0 / sysFragCoordVary.w;
  vec2 uv = vec2( sysFragCoordVary.x, sysFragCoordVary.y ) * invW;
#if defined( _TEXTURE_ORIGIN_LOWER_LEFT )
  return vec2( uv.x, 1.0 - uv.y );
#else
  return uv;
#endif
}
