﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ShaderGenerator.GLSL
{
    public class Variable
    {
        public class Assignment
        {
            public Assignment(string target, string expression)
            {
                if (string.IsNullOrWhiteSpace(target))
                    throw new ArgumentException(string.Format(Messages.EXCEPTION_INVALID_ARGUMENT, "target"), "target");
                if (string.IsNullOrWhiteSpace(expression))
                    throw new ArgumentException(string.Format(Messages.EXCEPTION_INVALID_ARGUMENT, "expression"), "expression");

                Target = target;
                Expression = expression;
            }

            public string Target { get; private set; }
            public string Expression { get; private set; }

            public override string ToString()
            {
                return string.Format("{0} <- {1}", Target, Expression);
            }
        }

        public Variable(ShaderTyping.ShaderTypeDefinition type, string name)
        {
            if (type == null)
                throw new ArgumentNullException("type");
            if (string.IsNullOrWhiteSpace(name))
                throw new ArgumentException(string.Format(Messages.EXCEPTION_INVALID_ARGUMENT, "name"), "name");

            Type = type;
            Name = name;
        }

        public ShaderTyping.ShaderTypeDefinition Type { get; private set; }
        public string Name { get; private set; }

        public override string ToString()
        {
            return string.Format("{0} {1}", Type, Name);
        }
    }
}
