﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Renderer2D.Core;
using System.ComponentModel.Composition;
using System.ComponentModel.Composition.Hosting;
using System.IO;
using System.Reflection;
using System.ComponentModel.Composition.Primitives;
using System.Threading;

namespace WinFormsTestApp
{
    public partial class frmMain : Form
    {
        public frmMain()
        {
            InitializeComponent();
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            Globals.SetCompositionReportManager(new ReportManager(lstCompositionReport));
            Globals.ReportManager.ItemAdded += (ss, ee) => splitContainerRoot.Panel2Collapsed = false;
            Globals.ReportManager.ItemsCleared += (ss, ee) => splitContainerRoot.Panel2Collapsed = true;

            Compose();
        }

        private void Compose()
        {
            var synchronizationContext = SynchronizationContext.Current;

            Globals.CompositionManager.ComposeAsync()
                .ContinueWith(task =>
                    {
                        if (task.IsFaulted)
                        {
                            var message = task.Exception != null ? task.Exception.Message : "No error information";
                            synchronizationContext.Post(() =>
                                Globals.ReportManager.AddErrorReport(new ErrorReport(message, ReportCategory.RendererComposition)));
                            return;
                        }

                        synchronizationContext.Post(CreateRendererControls);
                    });
        }

        private void CreateRendererControls()
        {
            pnlRendererDisplayControls.Controls.Clear();

            foreach (var renderer in Globals.CompositionManager.Renderers)
            {
                var rendererDisplayControl = new RendererDisplayControl();
                rendererDisplayControl.SetRenderer(renderer);

                pnlRendererDisplayControls.Controls.Add(rendererDisplayControl);
            }
        }

        private void btnClearReportLog_Click(object sender, EventArgs e)
        {
            Globals.ReportManager.Clear();
        }

        private void mnuFileRecomposeRenderers_Click(object sender, EventArgs e)
        {
            Compose();
        }

        private void mnuFileClose_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}
