﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Renderer2D.Core
{
    public struct Vector2D
    {
        public double X { get; private set; }
        public double Y { get; private set; }

        public Vector2D(double x, double y)
            : this()
        {
            X = x;
            Y = y;
        }

        public override string ToString()
        {
            return X.ToString() + "; " + Y.ToString();
        }

        public static Vector2D operator +(Vector2D u, Vector2D v) { return new Vector2D(u.X + v.X, u.Y + v.Y); }
        public static Vector2D operator -(Vector2D u, Vector2D v) { return new Vector2D(u.X - v.X, u.Y - v.Y); }
        public static Vector2D operator *(Vector2D u, double x) { return new Vector2D(u.X * x, u.Y * x); }
        public static Vector2D operator *(double x, Vector2D u) { return u * x; }
        public static Vector2D operator /(Vector2D u, double x)
        {
            var inv = 1.0 / x;
            return new Vector2D(u.X * inv, u.Y * inv);
        }

        public static Vector2D Mul(Vector2D u, Vector2D v) { return new Vector2D(u.X * v.X, u.Y * v.Y); }
        public static double Dot(Vector2D u, Vector2D v) { return u.X * v.X + u.Y * v.Y; }
        public double Norm() { return Math.Sqrt(Dot(this, this)); }

        public void Normalize()
        {
            this *= 1.0 / (Norm() + float.Epsilon);
        }
    }
}
