﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace Renderer2D.Core
{
    public interface ISize
    {
        double Width { get; set; }
        double Height { get; set; }
    }

    public class Size : ISize
    {
        public Size()
        {
        }

        public Size(double width, double height)
        {
            Width = width;
            Height = height;
        }

        public Size(ISize size)
        {
            if (size == null)
                throw new ArgumentNullException("size");

            Width = size.Width;
            Height = size.Height;
        }

        private double width;
        public double Width
        {
            get { return width; }
            set
            {
                if (value < 0.0)
                    throw new ArgumentOutOfRangeException("value", string.Format(Messages.EXCEPTION_GREATER_THAN_OR_EQUAL_TO_ZERO, "Width"));
                width = value;
            }
        }

        private double height;
        public double Height
        {
            get { return height; }
            set
            {
                if (value < 0.0)
                    throw new ArgumentOutOfRangeException("value", string.Format(Messages.EXCEPTION_GREATER_THAN_OR_EQUAL_TO_ZERO, "Height"));
                height = value;
            }
        }
    }
}
