﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using EnvironmentReporting;

namespace EnvironmentInformationProvider
{
    public class OSInformationProvider : IInformationProvider
    {
        public string InformationDescription { get { return "Operating System"; } }

        public ContextInformation GetInformation()
        {
            var OSinfo = new ContextInformationContainer();

            OSinfo.Add("OS", new StringContextInformation(Environment.OSVersion.VersionString));
            OSinfo.Add("Platform", new StringContextInformation(Environment.OSVersion.Platform.ToString()));
            OSinfo.Add("Version", new StringContextInformation(Environment.OSVersion.Version.ToString()));
            OSinfo.Add("Service pack", new StringContextInformation(Environment.OSVersion.ServicePack));

            OSinfo.Add("Debugging USER.EXE", new DecimalContextInformation(SystemInformation.DebugOS ? 1 : 0));
            OSinfo.Add("Security manager present", new DecimalContextInformation(SystemInformation.Secure ? 1 : 0));
            OSinfo.Add("Pen Computing extension installed", new DecimalContextInformation(SystemInformation.PenWindows ? 1 : 0));

            return OSinfo;
        }
    }
}
