﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectDefinitions
{
    /// <summary>
    /// Tag -- function pair, with source for all elements.
    /// </summary>
    public class TaggingWithSource : Tagging
    {
        public TaggingWithSource(Tagging tagging)
            : base(tagging.Source, tagging.Name, tagging.FunctionId)
        {
            NameSource = null;
            FunctionIdSource = null;
        }

        public TaggingWithSource(DefinitionLocation source,
            DefinitionLocation nameSource, string name,
            DefinitionLocation functionIdSource, string functionId)
            : base(source, name, functionId)
        {
            NameSource = nameSource;
            FunctionIdSource = functionIdSource;
        }

        public DefinitionLocation NameSource { get; private set; }
        public DefinitionLocation FunctionIdSource { get; private set; }
    }
}
