﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectDefinitions
{
    /// <summary>
    /// ブロック内プレビューのソースです。
    /// </summary>
    public class PreviewDefinitionWithSource : PreviewDefinition
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="source">glslファイルのソース情報</param>
        /// <param name="enabledSource">glslファイルの有効状態情報</param>
        /// <param name="enabled">有効状態の文字列</param>
        /// <param name="locationSource">glslファイルの配置位置情報</param>
        /// <param name="location">配置位置の文字列</param>
        /// <param name="widthSource">glslファイルの幅情報</param>
        /// <param name="width">幅の文字列</param>
        /// <param name="heightSource">glslファイルの高さ情報です</param>
        /// <param name="height">高さの文字列</param>
        public PreviewDefinitionWithSource(
            DefinitionLocation source,
            DefinitionLocation enabledSource,
            string enabled,
            DefinitionLocation locationSource,
            string location,
            DefinitionLocation widthSource,
            string width,
            DefinitionLocation heightSource,
            string height)
            : base(enabled, location, width, height)
        {
            this.Source = source;
            this.EnabledSource = enabledSource;
            this.LocationSource = locationSource;
            this.WidthSource = widthSource;
            this.HeightSource = heightSource;
        }

        /// <summary>
        /// glslファイルのソース情報です。
        /// </summary>
        public DefinitionLocation Source { get; private set; }

        /// <summary>
        /// glslファイルの有効状態情報です。
        /// </summary>
        public DefinitionLocation EnabledSource { get; private set; }

        /// <summary>
        /// glslファイルの配置位置情報です。
        /// </summary>
        public DefinitionLocation LocationSource { get; private set; }

        /// <summary>
        /// glslファイルの幅情報です。
        /// </summary>
        public DefinitionLocation WidthSource { get; private set; }

        /// <summary>
        /// glslファイルの高さ情報です。
        /// </summary>
        public DefinitionLocation HeightSource { get; private set; }
    }
}
