﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace EffectDefinitions
{
    /// <summary>
    /// Definition of a shader language function parameter in a definitions file: on top of a type and name, it has a source and an optional usage and documentation.
    /// </summary>
    public class ParameterDefinition : ShaderTyping.ParameterDefinition
    {
        public static readonly string ReturnParameterString = "return";

        public ParameterDefinition(DefinitionLocation source,
            string name,
            ShaderTypeDefinition type,
            ShaderTyping.ParameterDirection direction,
            string usage,
            string description)
            : base(name, type, direction)
        {
            if (!Regex.IsMatch(name, Utility.ValidIdentifierRegEx))
                throw new ArgumentException(string.Format(Messages.NOT_VALID_IDENTIFIER, "name"), "name");
            if (type.IsVoid)
                throw new ArgumentException(Messages.EXCEPTION_ILLEGAL_PARAMETER_TYPE_VOID, "type");

            Source = source;
            Usage = usage;
            Description = description;
        }

        public DefinitionLocation Source { get; private set; }

        public string Usage { get; private set; }
        public string Description { get; private set; }

        #region Equals

        public override bool Equals(object obj)
        {
            var other = obj as ParameterDefinition;
            return other != null && Equals(other);
        }

        public override bool Equals(ShaderTyping.ParameterDefinition other)
        {
            if ((object)other == null)
                return false;

            if (!(other is ParameterDefinition))
                return false;

            var p = (ParameterDefinition)other;

            return base.Equals(other) &&
                Usage == p.Usage &&
                Description == p.Description;
        }

        public override int GetHashCode()
        {
            return (base.GetHashCode().ToString() +
                Usage +
                Description).GetHashCode();
        }

        #endregion
    }
}
