﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectDefinitions.EquivalenceComparers
{
    public class ParameterEquivalenceComparer : IEquivalenceComparer<ParameterDefinition>
    {
        public bool IsEquivalent(ParameterDefinition x, ParameterDefinition y)
        {
            if (x == null || y == null)
                return false;

            return x.Type == y.Type &&
                x.Name == y.Name &&
                x.Direction == y.Direction;
        }

        public int GetHashCode(ParameterDefinition obj)
        {
            return string.Join(":", obj.Type, obj.Name, obj.Direction, obj.Description).GetHashCode();
        }
    }
}
