﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectCombiner.Core
{
    public enum ReportLevel
    {
        Information,
        Warning,
        Error,
        Fatal,
    }

    public interface IEventReporter
    {
        void Report(EventReportBase eventReport);
    }

    public class EventReportBase : IDisposable
    {
        private Func<string> messageFunc;
        public string Message { get { return messageFunc != null ? messageFunc() : string.Empty; } }

        public ReportLevel Level { get; private set; }
        public DateTime IssueDate { get; private set; }
        public string Source { get; private set; }

        private Func<string> commentFunc;
        public string Comment { get { return commentFunc != null ? commentFunc() : string.Empty; } }

        public Exception Exception { get; private set; }

        public EventReportBase(Func<string> messageFunc, ReportLevel level, string source, Func<string> commentFunc, Exception exception)
        {
            this.messageFunc = messageFunc;
            Level = level;
            IssueDate = DateTime.Now;
            Source = source ?? string.Empty;
            this.commentFunc = commentFunc;
            Exception = exception;
        }

        public void Dispose()
        {
            messageFunc = null;
            commentFunc = null;

            OnDispose();
        }

        protected virtual void OnDispose()
        {
        }
    }
}
