﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectCombiner.Core.Extensions
{
    public static class EnumerableExtensions
    {
        public static bool One<T>(this IEnumerable<T> source, Func<T, bool> predicate)
        {
            return source.Count(predicate) == 1;
        }

        public static bool IsNullOrEmpty(this Array source)
        {
            return source == null || source.Length == 0;
        }

        public static bool IsNullOrEmpty(this IEnumerable source)
        {
            if (source == null)
                return true;

            return source.GetEnumerator().MoveNext() == false;
        }

        public static IEnumerable<T> Distinct<T>(this IEnumerable<T> source, Func<T, int> getHashCode, Func<T, T, bool> equals)
        {
            if (source == null)
                throw new ArgumentNullException("source");
            if (getHashCode == null)
                throw new ArgumentNullException("getHashCode");
            if (equals == null)
                throw new ArgumentNullException("equals");

            return source.Distinct(new AnonymousEqualityComparer<T>(getHashCode, equals));
        }

        public static bool MoreThanOne(this IEnumerable source)
        {
            if (source == null)
                throw new ArgumentNullException("source");

            var e = source.GetEnumerator();
            return e.MoveNext() && e.MoveNext();
        }
    }
}
