﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Communication.EffectCombiner;
using Communication.Contracts;
using System.ServiceModel;

namespace UnitTests
{
    [ServiceBehavior(InstanceContextMode = InstanceContextMode.Single)]
    public class TestShaderTransferService : IShaderTransferService
    {
        private readonly Func<string, string, ShaderTransferResult> transfer;
        public TestShaderTransferService(Func<string, string, ShaderTransferResult> transfer)
        {
            this.transfer = transfer;
        }

        public ShaderTransferResult Transfer(string filePath, string shaderCode)
        {
            return transfer(filePath, shaderCode);
        }
    }
}
