﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using EffectCombiner.Primitives.Generation;
using EffectCombiner.Primitives.Generation.Usage;
using EffectDefinitions;


namespace EffectCombinerUnitTests
{
    public static class Utility
    {
        public static Plug CreatePlug(string name, string typeName, bool isInput)
        {
            return new Plug(name, new ShaderTypeDefinition(typeName), "foo." + name, isInput, null, null);
        }

        public static Plug CreateInputPlug(string name, string typeName)
        {
            return CreatePlug(name, typeName, true);
        }

        public static Plug CreateOutputPlug(string name, string typeName)
        {
            return CreatePlug(name, typeName, true);
        }

        public static RegularEffectBlockElement CreateDummyBlock(Plug[] inputPlugs, Plug[] outputPlugs)
        {
            var dummyLocation = new DefinitionLocation(new Uri("http://127.0.0.1"));
            var blockDefinition = new BlockDefinition(dummyLocation, "dummy", "dummy", inputPlugs, outputPlugs);
            return new RegularEffectBlockElement(blockDefinition);
        }

        public static RegularEffectBlockElement CreateDummyInputBlock(params Plug[] inputPlugs)
        {
            return CreateDummyBlock(inputPlugs, new Plug[] { });
        }

        public static RegularEffectBlockElement CreateDummyOutputBlock(params Plug[] outputPlugs)
        {
            return CreateDummyBlock(new Plug[] { }, outputPlugs);
        }

        public static void OutputsShouldBeProperlyConnected(IUsageDescriptor usage, EffectOutputPlug plug, EffectOutputPlug[] subPlugs)
        {
            if (usage.AreOutputsProperlyConnected(plug, subPlugs) == false)
                throw new Exception("Outputs are reported not to be properly connected while they are.");
        }

        public static void OutputsShouldNotBeProperlyConnected(IUsageDescriptor usage, EffectOutputPlug plug, EffectOutputPlug[] subPlugs)
        {
            if (usage.AreOutputsProperlyConnected(plug, subPlugs) == true)
                throw new Exception("Outputs are reported to be properly connected while they are not.");
        }

        public static void InputsShouldBeProperlyConnected(IUsageDescriptor usage, EffectInputPlug plug, EffectInputPlug[] subPlugs)
        {
            if (usage.AreInputsProperlyConnected(plug, subPlugs) == false)
                throw new Exception("Outputs are reported not to be properly connected while they are.");
        }

        public static void InputsShouldNotBeProperlyConnected(IUsageDescriptor usage, EffectInputPlug plug, EffectInputPlug[] subPlugs)
        {
            if (usage.AreInputsProperlyConnected(plug, subPlugs) == true)
                throw new Exception("Outputs are reported to be properly connected while they are not.");
        }
    }
}
