﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using EffectCombiner.Primitives.Generation.Usage;
using EffectCombiner.Primitives.Generation.Usage.Descriptors;
using Microsoft.VisualStudio.TestTools.UnitTesting;


namespace EffectCombinerUnitTests
{
    [TestClass]
    public class UsageDescriptorTest
    {
        [TestMethod]
        public void GetUsageByNameTest()
        {
            var colorUsage = new ColorUsageDescriptor();
            var textureUsage = new ColorUsageDescriptor();

            if (UsageManager.GetUsageByName("test") != null)
                throw new Exception(string.Format("GetUsageByName returned something for \"{0}\"", "test"));

            if (UsageManager.GetUsageByName(colorUsage.Name) == null)
                throw new Exception(string.Format("GetUsageByName returned null for \"{0}\"", colorUsage.Name));

            if (UsageManager.GetUsageByName(textureUsage.Name) == null)
                throw new Exception(string.Format("GetUsageByName returned null for \"{0}\"", textureUsage.Name));
        }
    }
}
