﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using EffectDefinitions;
using EffectCombiner.Primitives;

namespace EffectCombinerUnitTests
{
    [TestClass]
    public class FakeBlockDefinitionTest
    {
        [TestMethod]
        public void PlugsTest()
        {
            for (int j = 0; j < 50; ++j)
                for (int i = 0; i < 50; ++i)
                {
                    if (i == 0 && j == 0)
                        continue;

                    var block = new FakeBlockDefinition("foo", i, j);
                    if (block.InputPlugs.Length != i)
                        throw new Exception(string.Format("FakeBlock should have {0} input plugs but has {1}", i, block.InputPlugs.Length));
                    if (block.OutputPlugs.Length != j)
                        throw new Exception(string.Format("FakeBlock should have {0} input plugs but has {1}", j, block.OutputPlugs.Length));
                }
        }
    }
}
