﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using EffectCombiner.Core;
using EffectCombiner.Primitives.Blocks;
using EffectCombiner.Primitives.Constant;
using EffectCombiner.Primitives.Generation;
using EffectCombiner.Primitives.Operations;

namespace EffectCombiner.Primitives
{
    public static class Globals
    {
        static Globals()
        {
            ContentRepository = new CustomContentRepository(CacheMode.Compressed);
            Localization = new LocalizationManager();
        }

        public static IWorkspaceManager WorkspaceManager { get; private set; }
        public static IBlockElementEditPanel EffectBlockElementPanel { get; private set; }
        public static IBlockElementEditPanel ConstantValuePanel { get; private set; }
        public static IBlockElementEditPanel CommentTextPanel { get; private set; }
        public static QuickInfo QuickInfo { get; private set; }
        public static IContentRepository ContentRepository { get; private set; }
        public static CustomOperationManager MainOperationManager { get; private set; }
        public static Options Options { get; private set; }
        public static LocalizationManager Localization { get; private set; }
        public static VisualResourceSet VisualResources { get; private set; }

        public static void SetVisualResourceSet(VisualResourceSet resourceSet)
        {
            if (resourceSet == null)
                throw new ArgumentNullException("resourceSet");
            VisualResources = resourceSet;
        }

        public static void SetWorkspaceManager(IWorkspaceManager workspaceManager)
        {
            if (workspaceManager == null)
                throw new ArgumentNullException("workspaceManager");
            WorkspaceManager = workspaceManager;
        }

        /// <summary>
        /// Constantブロック値の編集パネルを設定します。
        /// </summary>
        /// <param name="constantValuePanel">Constantブロック値の編集パネル</param>
        public static void SetConstantValuePanel(IBlockElementEditPanel constantValuePanel)
        {
            if (constantValuePanel == null)
                throw new ArgumentNullException("constantValuePanel");
            ConstantValuePanel = constantValuePanel;
        }

        /// <summary>
        /// ブロックパネルを設定します。
        /// </summary>
        /// <param name="effectBlockPanel">ブロックの編集パネル</param>
        public static void SetEffectBlockElementPanel(IBlockElementEditPanel effectBlockPanel)
        {
            if (effectBlockPanel == null)
            {
                throw new ArgumentNullException("regularEffectValuePanel");
            }

            EffectBlockElementPanel = effectBlockPanel;
        }

        /// <summary>
        /// Commentブロック値の編集パネルを設定します。
        /// </summary>
        /// <param name="commentTextPanel">Commentブロック値の編集パネル</param>
        public static void SetCommentTextPanel(IBlockElementEditPanel commentTextPanel)
        {
            if (commentTextPanel == null)
                throw new ArgumentNullException("commentTextPanel");
            CommentTextPanel = commentTextPanel;
        }

        public static void SetOptions(Options options)
        {
            if (options == null)
                throw new ArgumentNullException("options");
            Options = options;
        }

        public static void SetMainOperationManager(CustomOperationManager _mainOperationManager)
        {
            if (_mainOperationManager == null)
                throw new ArgumentNullException("_mainOperationManager");
            MainOperationManager = _mainOperationManager;
        }

        public static void SetQuickInfo(QuickInfo quickInfo)
        {
            if (quickInfo == null)
                throw new ArgumentNullException("quickInfo");
            QuickInfo = quickInfo;
        }
    }
}
