﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;
using EffectCombiner.Primitives.Generation;

namespace EffectCombiner.Primitives.Constant
{
    public interface IDataTypeDescriptor
    {
        PrimitiveShaderType DataType { get; }

        Control ProduceControl();

        string GetValue(Control control);
        void SetValue(Control control, string value);

        IDisposable AttachHandlers(Control control, EventHandler onChanged, EventHandler onValidated);
    }
}
