﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectCombiner.Core;

namespace EffectCombiner.Primitives.Generation
{
    public class CustomContentRepository : ContentRepository
    {
        private readonly Dictionary<Uri, string> customContent = new Dictionary<Uri, string>();

        public CustomContentRepository(CacheMode cacheMode)
            : base(cacheMode)
        {
        }

        private const string AutoGenScheme = "autogen";

        protected override string ResolveResourceContent(Uri resourceLocation)
        {
            if (resourceLocation.Scheme == AutoGenScheme)
            {
                string content;
                if (customContent.TryGetValue(resourceLocation, out content))
                    return content;
                return string.Empty;
            }

            return customContent[resourceLocation];
        }

        public void SetCustomContent(string id, string content)
        {
            var uri = new Uri(string.Format("{0}://{1}", AutoGenScheme, id));
            customContent[uri] = content;
        }
    }
}
