﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;

namespace EffectCombiner.Primitives.Generation
{
    public class CommentBlockElement : RegularEffectBlockElement
    {
        public CommentBlockElement()
            : base(new CommentBlockDefinition())
        {
            UpdateData();
        }

        private string[,] values;
        public string[,] Values
        {
            get { return values; }
            set
            {
                if (values == value)
                    return;

                values = value;
                OnValuesChanged();
            }
        }

        public string Text
        {
            get
            {
                var def = BlockDefinition as CommentBlockDefinition;
                Debug.Assert(def != null);
                return def.Text;
            }

            set
            {
                var def = BlockDefinition as CommentBlockDefinition;
                Debug.Assert(def != null);
                def.Text = value;
                if (Values == null)
                {
                    Values = new string[1, 1];
                }

                Values[0, 0] = value;
            }
        }

        public event EventHandler ValuesChanged;

        protected virtual void OnValuesChanged()
        {
            var handler = ValuesChanged;
            if (handler != null)
                handler(this, EventArgs.Empty);
        }

        public void SetupCommentBlockElement(string constValues)
        {
            UpdateBlockDefinition(new CommentBlockDefinition());
            UpdateData();

            var array = Core.CoreUtility.StringToMultiDimArray(constValues, 1, 1);

            Core.CoreUtility.ArrayCopy(Values, array);
            var def = this.BlockDefinition as CommentBlockDefinition;
            Debug.Assert(def != null);
            def.Text = Values[0, 0];
        }

        public void UpdateData()
        {
            var array = new string[1, 1];
            Core.CoreUtility.ArrayCopy(array, Values);

            Values = array;
            var def = this.BlockDefinition as CommentBlockDefinition;
            Debug.Assert(def != null);
            Values[0, 0] = def.Text;
        }
    }
}
