﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectDefinitions;
using ShaderGenerator.GLSL;

namespace EffectCombiner.Primitives.Generation.AutoGen.Operators
{
    public class NormalizeOperatorDefinitionSet : IAutoDefinitionSet
    {
        private static string MakeShaderCode(string funcName, string type, string paramName)
        {
            var sb = new StringBuilder();
            sb.AppendLine(string.Format("{0} {1}( {0} {2} )", type, funcName, paramName));
            sb.AppendLine("{");
            sb.AppendLine(string.Format("    return normalize( {0} );", paramName));
            sb.AppendLine("}");

            return sb.ToString();
        }

        public NormalizeOperatorDefinitionSet()
        {
            var paramNames = new[] { "v" };
            var supportedFunctionPrototypes = new[]
            {
                // 返り値, 引数1, 引数2, ...
                new[] { "vec2", "vec2" },
                new[] { "vec3", "vec3" },
                new[] { "vec4", "vec4" },
            };

            FunctionDefinitions = OperatorDefinitionSetUtility.CreateFunctions(this, supportedFunctionPrototypes, paramNames);
            BlockDefinition = new PolymorphicBlockDefinition(BlockName, Guid, FunctionDefinitions);

            ShaderCodes = new[]
            {
                MakeShaderCode( FunctionName, "vec2", paramNames[ 0 ] ),    // vec2
                MakeShaderCode( FunctionName, "vec3", paramNames[ 0 ] ),    // vec3
                MakeShaderCode( FunctionName, "vec4", paramNames[ 0 ] ),    // vec4
            };
        }

        public string Guid
        {
            get { return "{5878A657-FC6C-4679-B190-664B7806BE0C}"; }
        }

        public string FunctionName
        {
            get { return "Normalize"; }
        }

        public string BlockName
        {
            get { return "Normalize"; }
        }

        public FunctionDefinition[] FunctionDefinitions { get; private set; }
        public PolymorphicBlockDefinition BlockDefinition { get; private set; }
        public string[] ShaderCodes { get; private set; }
    }
}
